/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.exceptions;

import com.microsoft.semantickernel.exceptions.SKCheckedException;
import com.microsoft.semantickernel.localization.SemanticKernelResources;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ConfigurationException
extends SKCheckedException {
    @Nonnull
    private final ErrorCodes errorCode;

    public ConfigurationException(@Nonnull ErrorCodes error) {
        this(error, null, null);
    }

    public ConfigurationException(@Nonnull ErrorCodes errorCode, @Nullable String message) {
        this(errorCode, message, null);
    }

    public ConfigurationException(@Nonnull ErrorCodes errorCode, @Nullable String message, @Nullable Throwable innerException) {
        super(ConfigurationException.formatDefaultMessage(errorCode.getMessage(), message), innerException);
        this.errorCode = errorCode;
    }

    public ErrorCodes getErrorCode() {
        return this.errorCode;
    }

    public static enum ErrorCodes {
        UNKNOWN_ERROR(SemanticKernelResources.getString("unknown.error")),
        CONFIGURATION_NOT_FOUND(SemanticKernelResources.getString("could.not.find.configuration.file")),
        COULD_NOT_READ_CONFIGURATION(SemanticKernelResources.getString("could.not.parse.or.load.configuration.file")),
        NO_VALID_CONFIGURATIONS_FOUND(SemanticKernelResources.getString("could.not.find.any.valid.configuration.settings")),
        VALUE_NOT_FOUND(SemanticKernelResources.getString("could.not.find.value.for.configuration.key"));

        private final String message;

        private ErrorCodes(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }

        public String getMessage(String param) {
            return String.format(this.message, param);
        }
    }
}

