/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.data.textsearch;

import com.microsoft.semantickernel.data.textsearch.TextSearchFilter;

public class TextSearchOptions {
    public static final int DEFAULT_TOP = 3;
    private final boolean includeTotalCount;
    private final int top;
    private final int skip;
    private final TextSearchFilter filter;

    public static TextSearchOptions createDefault() {
        return new TextSearchOptions(false, 3, 0, null);
    }

    TextSearchOptions(boolean includeTotalCount, int top, int skip, TextSearchFilter filter) {
        this.includeTotalCount = includeTotalCount;
        this.top = top;
        this.skip = skip;
        this.filter = filter;
    }

    public boolean isIncludeTotalCount() {
        return this.includeTotalCount;
    }

    public int getTop() {
        return this.top;
    }

    public int getSkip() {
        return this.skip;
    }

    public TextSearchFilter getFilter() {
        return this.filter;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean includeTotalCount = false;
        private int top = 3;
        private int skip = 0;
        private TextSearchFilter filter;

        public Builder withIncludeTotalCount(boolean includeTotalCount) {
            this.includeTotalCount = includeTotalCount;
            return this;
        }

        public Builder withTop(int top) {
            this.top = top;
            return this;
        }

        public Builder withSkip(int skip) {
            this.skip = skip;
            return this;
        }

        public Builder withFilter(TextSearchFilter filter) {
            this.filter = filter;
            return this;
        }

        public TextSearchOptions build() {
            return new TextSearchOptions(this.includeTotalCount, this.top, this.skip, this.filter);
        }
    }
}

