/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.data.textsearch;

import com.microsoft.semantickernel.data.filter.EqualToFilterClause;
import com.microsoft.semantickernel.data.filter.FilterClause;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TextSearchFilter {
    private final List<FilterClause> filterClauses;

    public TextSearchFilter() {
        this(Collections.emptyList());
    }

    public TextSearchFilter(List<FilterClause> filterClauses) {
        this.filterClauses = Collections.unmodifiableList(filterClauses);
    }

    public List<FilterClause> getFilterClauses() {
        return this.filterClauses;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final List<FilterClause> filterClauses = new ArrayList<FilterClause>();

        public Builder equalTo(String fieldName, Object value) {
            this.filterClauses.add(new EqualToFilterClause(fieldName, value));
            return this;
        }

        public TextSearchFilter build() {
            return new TextSearchFilter(this.filterClauses);
        }
    }
}

