/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.semantickernel.services.chatcompletion;

import com.microsoft.semantickernel.orchestration.FunctionResultMetadata;
import com.microsoft.semantickernel.services.KernelContent;
import com.microsoft.semantickernel.services.chatcompletion.AuthorRole;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public class ChatMessageContent<T>
extends KernelContent<T> {
    private final AuthorRole authorRole;
    @Nullable
    private final String content;
    @Nullable
    private final List<KernelContent<T>> items;
    @Nullable
    private final Charset encoding;

    public ChatMessageContent(AuthorRole authorRole, String content) {
        this(authorRole, content, null, null, null, null);
    }

    public ChatMessageContent(AuthorRole authorRole, String content, @Nullable String modelId, @Nullable T innerContent, @Nullable Charset encoding, @Nullable FunctionResultMetadata metadata) {
        super(innerContent, modelId, metadata);
        this.authorRole = authorRole;
        this.content = content;
        this.encoding = encoding != null ? encoding : StandardCharsets.UTF_8;
        this.items = null;
    }

    public ChatMessageContent(AuthorRole authorRole, List<KernelContent<T>> items, String modelId, T innerContent, Charset encoding, FunctionResultMetadata metadata) {
        super(innerContent, modelId, metadata);
        this.content = null;
        this.authorRole = authorRole;
        this.encoding = encoding != null ? encoding : StandardCharsets.UTF_8;
        this.items = new ArrayList<KernelContent<T>>(items);
    }

    public AuthorRole getAuthorRole() {
        return this.authorRole;
    }

    @Override
    @Nullable
    public String getContent() {
        return this.content;
    }

    public List<KernelContent<T>> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    @Nullable
    public Charset getEncoding() {
        return this.encoding;
    }

    public String toString() {
        return this.content != null ? this.content : "";
    }
}

