/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;

public abstract class Driver {
    private static Driver instance;

    public static synchronized Path ensureDriverInstalled(Map<String, String> env) {
        if (instance == null) {
            try {
                instance = Driver.createDriver();
                instance.initialize(env);
            }
            catch (Exception exception) {
                throw new RuntimeException("Failed to create driver", exception);
            }
        }
        return instance.driverPath();
    }

    protected abstract void initialize(Map<String, String> var1) throws Exception;

    public Path driverPath() {
        String cliFileName = System.getProperty("os.name").toLowerCase().contains("windows") ? "playwright.cmd" : "playwright.sh";
        return this.driverDir().resolve(cliFileName);
    }

    public static void setRequiredEnvironmentVariables(ProcessBuilder pb) {
        if (!pb.environment().containsKey("PW_CLI_TARGET_LANG")) {
            pb.environment().put("PW_CLI_TARGET_LANG", "java");
            pb.environment().put("PW_CLI_TARGET_LANG_VERSION", Driver.getMajorJavaVersion());
        }
    }

    private static String getMajorJavaVersion() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            return version.substring(2, 3);
        }
        int dot = version.indexOf(".");
        if (dot != -1) {
            return version.substring(0, dot);
        }
        return version;
    }

    private static Driver createDriver() throws Exception {
        String pathFromProperty = System.getProperty("playwright.cli.dir");
        if (pathFromProperty != null) {
            return new PreinstalledDriver(Paths.get(pathFromProperty, new String[0]));
        }
        Class<?> jarDriver = Class.forName("com.microsoft.playwright.impl.DriverJar");
        return (Driver)jarDriver.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    abstract Path driverDir();

    private static class PreinstalledDriver
    extends Driver {
        private final Path driverDir;

        PreinstalledDriver(Path driverDir) {
            this.driverDir = driverDir;
        }

        @Override
        protected void initialize(Map<String, String> env) {
        }

        @Override
        Path driverDir() {
            return this.driverDir;
        }
    }
}

