/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.kiota;

import com.microsoft.kiota.ApiException;
import com.microsoft.kiota.ResponseHeaders;
import com.microsoft.kiota.serialization.Parsable;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.function.Supplier;

public class ApiExceptionBuilder {
    private ApiException value = null;

    public ApiExceptionBuilder() {
    }

    public ApiExceptionBuilder(@Nonnull Supplier<Parsable> builder) {
        Objects.requireNonNull(builder);
        Parsable error = builder.get();
        this.value = error instanceof ApiException ? (ApiException)((Object)error) : new ApiExceptionBuilder().withMessage("\"unexpected error type \"" + error.getClass().getName()).build();
    }

    @Nonnull
    public ApiExceptionBuilder withMessage(@Nonnull String message) {
        Objects.requireNonNull(message);
        this.value = this.value == null ? new ApiException(message) : new ApiException(message, this.value.getCause());
        return this;
    }

    @Nonnull
    public ApiExceptionBuilder withThrowable(@Nonnull Throwable exception) {
        Objects.requireNonNull(exception);
        this.value = this.value == null ? new ApiException(exception) : new ApiException(this.value.getMessage(), this.value.getCause());
        return this;
    }

    @Nonnull
    public ApiExceptionBuilder withResponseStatusCode(int responseStatusCode) {
        if (this.value == null) {
            this.value = new ApiException();
        }
        this.value.setResponseStatusCode(responseStatusCode);
        return this;
    }

    @Nonnull
    public ApiExceptionBuilder withResponseHeaders(@Nonnull ResponseHeaders responseHeaders) {
        if (this.value == null) {
            this.value = new ApiException();
        }
        this.value.setResponseHeaders(responseHeaders);
        return this;
    }

    @Nonnull
    public ApiException build() {
        ApiException result = this.value;
        this.value = null;
        return result;
    }
}

