/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.ItemActivity;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ItemActivityRequest
extends BaseRequest<ItemActivity> {
    public ItemActivityRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ItemActivity.class);
    }

    @Nonnull
    public CompletableFuture<ItemActivity> getAsync() {
        return this.sendAsync(HttpMethod.GET, null);
    }

    @Nullable
    public ItemActivity get() throws ClientException {
        return (ItemActivity)this.send(HttpMethod.GET, null);
    }

    @Nonnull
    public CompletableFuture<ItemActivity> deleteAsync() {
        return this.sendAsync(HttpMethod.DELETE, null);
    }

    @Nullable
    public ItemActivity delete() throws ClientException {
        return (ItemActivity)this.send(HttpMethod.DELETE, null);
    }

    @Nonnull
    public CompletableFuture<ItemActivity> patchAsync(@Nonnull ItemActivity sourceItemActivity) {
        return this.sendAsync(HttpMethod.PATCH, sourceItemActivity);
    }

    @Nullable
    public ItemActivity patch(@Nonnull ItemActivity sourceItemActivity) throws ClientException {
        return (ItemActivity)this.send(HttpMethod.PATCH, sourceItemActivity);
    }

    @Nonnull
    public CompletableFuture<ItemActivity> postAsync(@Nonnull ItemActivity newItemActivity) {
        return this.sendAsync(HttpMethod.POST, newItemActivity);
    }

    @Nullable
    public ItemActivity post(@Nonnull ItemActivity newItemActivity) throws ClientException {
        return (ItemActivity)this.send(HttpMethod.POST, newItemActivity);
    }

    @Nonnull
    public CompletableFuture<ItemActivity> putAsync(@Nonnull ItemActivity newItemActivity) {
        return this.sendAsync(HttpMethod.PUT, newItemActivity);
    }

    @Nullable
    public ItemActivity put(@Nonnull ItemActivity newItemActivity) throws ClientException {
        return (ItemActivity)this.send(HttpMethod.PUT, newItemActivity);
    }

    @Nonnull
    public ItemActivityRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public ItemActivityRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }
}

