// Template Source: BaseEntityCollectionRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.WorkbookWorksheet;
import com.microsoft.graph.models.WorkbookChart;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.WorkbookChartCollectionRequestBuilder;
import com.microsoft.graph.requests.WorkbookChartRequestBuilder;
import com.microsoft.graph.requests.WorkbookChartCollectionRequest;
import com.microsoft.graph.requests.WorkbookChartAddRequestBuilder;
import com.microsoft.graph.requests.WorkbookChartCountRequestBuilder;
import com.microsoft.graph.requests.WorkbookChartItemRequestBuilder;
import com.microsoft.graph.requests.WorkbookChartItemAtRequestBuilder;
import com.microsoft.graph.http.BaseCollectionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.models.WorkbookChartAddParameterSet;
import com.microsoft.graph.models.WorkbookChartSetDataParameterSet;
import com.microsoft.graph.models.WorkbookChartSetPositionParameterSet;
import com.microsoft.graph.models.WorkbookChartItemParameterSet;
import com.microsoft.graph.models.WorkbookChartItemAtParameterSet;
import com.microsoft.graph.models.WorkbookChartImageParameterSet;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Chart Collection Request Builder.
 */
public class WorkbookChartCollectionRequestBuilder extends BaseCollectionRequestBuilder<WorkbookChart, WorkbookChartRequestBuilder, WorkbookChartCollectionResponse, WorkbookChartCollectionPage, WorkbookChartCollectionRequest> {

    /**
     * The request builder for this collection of WorkbookWorksheet
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WorkbookChartCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, WorkbookChartRequestBuilder.class, WorkbookChartCollectionRequest.class);
    }



    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public WorkbookChartAddRequestBuilder add(@Nonnull final WorkbookChartAddParameterSet parameters) {
        return new WorkbookChartAddRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.add"), getClient(), null, parameters);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     */
    @Nonnull
    public WorkbookChartCountRequestBuilder count() {
        return new WorkbookChartCountRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.count"), getClient(), null);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public WorkbookChartItemRequestBuilder item(@Nonnull final WorkbookChartItemParameterSet parameters) {
        return new WorkbookChartItemRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.item"), getClient(), null, parameters);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public WorkbookChartItemAtRequestBuilder itemAt(@Nonnull final WorkbookChartItemAtParameterSet parameters) {
        return new WorkbookChartItemAtRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.itemAt"), getClient(), null, parameters);
    }
}
