// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.UserTeamwork;
import com.microsoft.graph.models.TeamworkActivityTopic;
import com.microsoft.graph.models.ItemBody;
import com.microsoft.graph.models.KeyValuePair;
import com.microsoft.graph.requests.UserScopeTeamsAppInstallationCollectionRequestBuilder;
import com.microsoft.graph.requests.UserScopeTeamsAppInstallationRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the User Teamwork Request.
 */
public class UserTeamworkRequest extends BaseRequest<UserTeamwork> {
	
    /**
     * The request for the UserTeamwork
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public UserTeamworkRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, UserTeamwork.class);
    }

    /**
     * Gets the UserTeamwork from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserTeamwork> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the UserTeamwork from the service
     *
     * @return the UserTeamwork from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserTeamwork get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserTeamwork> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public UserTeamwork delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this UserTeamwork with a source
     *
     * @param sourceUserTeamwork the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserTeamwork> patchAsync(@Nonnull final UserTeamwork sourceUserTeamwork) {
        return sendAsync(HttpMethod.PATCH, sourceUserTeamwork);
    }

    /**
     * Patches this UserTeamwork with a source
     *
     * @param sourceUserTeamwork the source object with updates
     * @return the updated UserTeamwork
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserTeamwork patch(@Nonnull final UserTeamwork sourceUserTeamwork) throws ClientException {
        return send(HttpMethod.PATCH, sourceUserTeamwork);
    }

    /**
     * Creates a UserTeamwork with a new object
     *
     * @param newUserTeamwork the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserTeamwork> postAsync(@Nonnull final UserTeamwork newUserTeamwork) {
        return sendAsync(HttpMethod.POST, newUserTeamwork);
    }

    /**
     * Creates a UserTeamwork with a new object
     *
     * @param newUserTeamwork the new object to create
     * @return the created UserTeamwork
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserTeamwork post(@Nonnull final UserTeamwork newUserTeamwork) throws ClientException {
        return send(HttpMethod.POST, newUserTeamwork);
    }

    /**
     * Creates a UserTeamwork with a new object
     *
     * @param newUserTeamwork the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserTeamwork> putAsync(@Nonnull final UserTeamwork newUserTeamwork) {
        return sendAsync(HttpMethod.PUT, newUserTeamwork);
    }

    /**
     * Creates a UserTeamwork with a new object
     *
     * @param newUserTeamwork the object to create/update
     * @return the created UserTeamwork
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserTeamwork put(@Nonnull final UserTeamwork newUserTeamwork) throws ClientException {
        return send(HttpMethod.PUT, newUserTeamwork);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public UserTeamworkRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public UserTeamworkRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

