// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.TeamworkHostedContent;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Teamwork Hosted Content Request.
 */
public class TeamworkHostedContentRequest extends BaseRequest<TeamworkHostedContent> {
	
    /**
     * The request for the TeamworkHostedContent
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param responseClass  the class of the response
     */
    public TeamworkHostedContentRequest(@Nonnull final String requestUrl,
            @Nonnull final IBaseClient<?> client,
            @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions,
            @Nonnull final Class<? extends TeamworkHostedContent> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * The request for the TeamworkHostedContent
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public TeamworkHostedContentRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, TeamworkHostedContent.class);
    }

    /**
     * Gets the TeamworkHostedContent from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TeamworkHostedContent> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the TeamworkHostedContent from the service
     *
     * @return the TeamworkHostedContent from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TeamworkHostedContent get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TeamworkHostedContent> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public TeamworkHostedContent delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this TeamworkHostedContent with a source
     *
     * @param sourceTeamworkHostedContent the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TeamworkHostedContent> patchAsync(@Nonnull final TeamworkHostedContent sourceTeamworkHostedContent) {
        return sendAsync(HttpMethod.PATCH, sourceTeamworkHostedContent);
    }

    /**
     * Patches this TeamworkHostedContent with a source
     *
     * @param sourceTeamworkHostedContent the source object with updates
     * @return the updated TeamworkHostedContent
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TeamworkHostedContent patch(@Nonnull final TeamworkHostedContent sourceTeamworkHostedContent) throws ClientException {
        return send(HttpMethod.PATCH, sourceTeamworkHostedContent);
    }

    /**
     * Creates a TeamworkHostedContent with a new object
     *
     * @param newTeamworkHostedContent the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TeamworkHostedContent> postAsync(@Nonnull final TeamworkHostedContent newTeamworkHostedContent) {
        return sendAsync(HttpMethod.POST, newTeamworkHostedContent);
    }

    /**
     * Creates a TeamworkHostedContent with a new object
     *
     * @param newTeamworkHostedContent the new object to create
     * @return the created TeamworkHostedContent
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TeamworkHostedContent post(@Nonnull final TeamworkHostedContent newTeamworkHostedContent) throws ClientException {
        return send(HttpMethod.POST, newTeamworkHostedContent);
    }

    /**
     * Creates a TeamworkHostedContent with a new object
     *
     * @param newTeamworkHostedContent the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TeamworkHostedContent> putAsync(@Nonnull final TeamworkHostedContent newTeamworkHostedContent) {
        return sendAsync(HttpMethod.PUT, newTeamworkHostedContent);
    }

    /**
     * Creates a TeamworkHostedContent with a new object
     *
     * @param newTeamworkHostedContent the object to create/update
     * @return the created TeamworkHostedContent
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TeamworkHostedContent put(@Nonnull final TeamworkHostedContent newTeamworkHostedContent) throws ClientException {
        return send(HttpMethod.PUT, newTeamworkHostedContent);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public TeamworkHostedContentRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public TeamworkHostedContentRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

