// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.PrintUsageByPrinter;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Print Usage By Printer Request.
 */
public class PrintUsageByPrinterRequest extends BaseRequest<PrintUsageByPrinter> {
	
    /**
     * The request for the PrintUsageByPrinter
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PrintUsageByPrinterRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, PrintUsageByPrinter.class);
    }

    /**
     * Gets the PrintUsageByPrinter from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrintUsageByPrinter> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the PrintUsageByPrinter from the service
     *
     * @return the PrintUsageByPrinter from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrintUsageByPrinter get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrintUsageByPrinter> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public PrintUsageByPrinter delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this PrintUsageByPrinter with a source
     *
     * @param sourcePrintUsageByPrinter the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrintUsageByPrinter> patchAsync(@Nonnull final PrintUsageByPrinter sourcePrintUsageByPrinter) {
        return sendAsync(HttpMethod.PATCH, sourcePrintUsageByPrinter);
    }

    /**
     * Patches this PrintUsageByPrinter with a source
     *
     * @param sourcePrintUsageByPrinter the source object with updates
     * @return the updated PrintUsageByPrinter
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrintUsageByPrinter patch(@Nonnull final PrintUsageByPrinter sourcePrintUsageByPrinter) throws ClientException {
        return send(HttpMethod.PATCH, sourcePrintUsageByPrinter);
    }

    /**
     * Creates a PrintUsageByPrinter with a new object
     *
     * @param newPrintUsageByPrinter the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrintUsageByPrinter> postAsync(@Nonnull final PrintUsageByPrinter newPrintUsageByPrinter) {
        return sendAsync(HttpMethod.POST, newPrintUsageByPrinter);
    }

    /**
     * Creates a PrintUsageByPrinter with a new object
     *
     * @param newPrintUsageByPrinter the new object to create
     * @return the created PrintUsageByPrinter
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrintUsageByPrinter post(@Nonnull final PrintUsageByPrinter newPrintUsageByPrinter) throws ClientException {
        return send(HttpMethod.POST, newPrintUsageByPrinter);
    }

    /**
     * Creates a PrintUsageByPrinter with a new object
     *
     * @param newPrintUsageByPrinter the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrintUsageByPrinter> putAsync(@Nonnull final PrintUsageByPrinter newPrintUsageByPrinter) {
        return sendAsync(HttpMethod.PUT, newPrintUsageByPrinter);
    }

    /**
     * Creates a PrintUsageByPrinter with a new object
     *
     * @param newPrintUsageByPrinter the object to create/update
     * @return the created PrintUsageByPrinter
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrintUsageByPrinter put(@Nonnull final PrintUsageByPrinter newPrintUsageByPrinter) throws ClientException {
        return send(HttpMethod.PUT, newPrintUsageByPrinter);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public PrintUsageByPrinterRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public PrintUsageByPrinterRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

