// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.Participant;
import com.microsoft.graph.models.InvitationParticipantInfo;
import com.microsoft.graph.models.InviteParticipantsOperation;
import com.microsoft.graph.models.MuteParticipantOperation;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Participant Request.
 */
public class ParticipantRequest extends BaseRequest<Participant> {
	
    /**
     * The request for the Participant
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ParticipantRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, Participant.class);
    }

    /**
     * Gets the Participant from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Participant> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the Participant from the service
     *
     * @return the Participant from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Participant get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Participant> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public Participant delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this Participant with a source
     *
     * @param sourceParticipant the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Participant> patchAsync(@Nonnull final Participant sourceParticipant) {
        return sendAsync(HttpMethod.PATCH, sourceParticipant);
    }

    /**
     * Patches this Participant with a source
     *
     * @param sourceParticipant the source object with updates
     * @return the updated Participant
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Participant patch(@Nonnull final Participant sourceParticipant) throws ClientException {
        return send(HttpMethod.PATCH, sourceParticipant);
    }

    /**
     * Creates a Participant with a new object
     *
     * @param newParticipant the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Participant> postAsync(@Nonnull final Participant newParticipant) {
        return sendAsync(HttpMethod.POST, newParticipant);
    }

    /**
     * Creates a Participant with a new object
     *
     * @param newParticipant the new object to create
     * @return the created Participant
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Participant post(@Nonnull final Participant newParticipant) throws ClientException {
        return send(HttpMethod.POST, newParticipant);
    }

    /**
     * Creates a Participant with a new object
     *
     * @param newParticipant the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Participant> putAsync(@Nonnull final Participant newParticipant) {
        return sendAsync(HttpMethod.PUT, newParticipant);
    }

    /**
     * Creates a Participant with a new object
     *
     * @param newParticipant the object to create/update
     * @return the created Participant
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Participant put(@Nonnull final Participant newParticipant) throws ClientException {
        return send(HttpMethod.PUT, newParticipant);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public ParticipantRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public ParticipantRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

