// Template Source: BaseMethodCollectionPage.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.LocaleInfo;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.requests.OutlookUserSupportedLanguagesCollectionRequestBuilder;
import com.microsoft.graph.requests.OutlookUserSupportedLanguagesCollectionPage;
import com.microsoft.graph.requests.OutlookUserSupportedLanguagesCollectionResponse;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Outlook User Supported Languages Collection Page.
 */
public class OutlookUserSupportedLanguagesCollectionPage extends BaseCollectionPage<LocaleInfo, OutlookUserSupportedLanguagesCollectionRequestBuilder> {

    /**
     * A collection page for LocaleInfo.
     *
     * @param response The serialized OutlookUserSupportedLanguagesCollectionResponse from the service
     * @param builder The request builder for the next collection page
     */
    public OutlookUserSupportedLanguagesCollectionPage(@Nonnull final OutlookUserSupportedLanguagesCollectionResponse response, @Nonnull final OutlookUserSupportedLanguagesCollectionRequestBuilder builder) {
       super(response, builder);
    }

	/**
     * Creates the collection page for OutlookUserSupportedLanguages
     *
     * @param pageContents       the contents of this page
     * @param nextRequestBuilder the request builder for the next page
     */
    public OutlookUserSupportedLanguagesCollectionPage(@Nonnull final java.util.List<LocaleInfo> pageContents, @Nullable final OutlookUserSupportedLanguagesCollectionRequestBuilder nextRequestBuilder) {
        super(pageContents, nextRequestBuilder);
    }
}
