// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.Onenote;
import com.microsoft.graph.requests.NotebookCollectionRequestBuilder;
import com.microsoft.graph.requests.NotebookRequestBuilder;
import com.microsoft.graph.requests.OnenoteOperationCollectionRequestBuilder;
import com.microsoft.graph.requests.OnenoteOperationRequestBuilder;
import com.microsoft.graph.requests.OnenotePageCollectionRequestBuilder;
import com.microsoft.graph.requests.OnenotePageRequestBuilder;
import com.microsoft.graph.requests.OnenoteResourceCollectionRequestBuilder;
import com.microsoft.graph.requests.OnenoteResourceRequestBuilder;
import com.microsoft.graph.requests.SectionGroupCollectionRequestBuilder;
import com.microsoft.graph.requests.SectionGroupRequestBuilder;
import com.microsoft.graph.requests.OnenoteSectionCollectionRequestBuilder;
import com.microsoft.graph.requests.OnenoteSectionRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Onenote Request.
 */
public class OnenoteRequest extends BaseRequest<Onenote> {
	
    /**
     * The request for the Onenote
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public OnenoteRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, Onenote.class);
    }

    /**
     * Gets the Onenote from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Onenote> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the Onenote from the service
     *
     * @return the Onenote from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Onenote get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Onenote> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public Onenote delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this Onenote with a source
     *
     * @param sourceOnenote the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Onenote> patchAsync(@Nonnull final Onenote sourceOnenote) {
        return sendAsync(HttpMethod.PATCH, sourceOnenote);
    }

    /**
     * Patches this Onenote with a source
     *
     * @param sourceOnenote the source object with updates
     * @return the updated Onenote
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Onenote patch(@Nonnull final Onenote sourceOnenote) throws ClientException {
        return send(HttpMethod.PATCH, sourceOnenote);
    }

    /**
     * Creates a Onenote with a new object
     *
     * @param newOnenote the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Onenote> postAsync(@Nonnull final Onenote newOnenote) {
        return sendAsync(HttpMethod.POST, newOnenote);
    }

    /**
     * Creates a Onenote with a new object
     *
     * @param newOnenote the new object to create
     * @return the created Onenote
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Onenote post(@Nonnull final Onenote newOnenote) throws ClientException {
        return send(HttpMethod.POST, newOnenote);
    }

    /**
     * Creates a Onenote with a new object
     *
     * @param newOnenote the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Onenote> putAsync(@Nonnull final Onenote newOnenote) {
        return sendAsync(HttpMethod.PUT, newOnenote);
    }

    /**
     * Creates a Onenote with a new object
     *
     * @param newOnenote the object to create/update
     * @return the created Onenote
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Onenote put(@Nonnull final Onenote newOnenote) throws ClientException {
        return send(HttpMethod.PUT, newOnenote);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public OnenoteRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public OnenoteRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

