// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.MobileAppContentFile;
import com.microsoft.graph.models.FileEncryptionInfo;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Mobile App Content File Request.
 */
public class MobileAppContentFileRequest extends BaseRequest<MobileAppContentFile> {
	
    /**
     * The request for the MobileAppContentFile
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public MobileAppContentFileRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, MobileAppContentFile.class);
    }

    /**
     * Gets the MobileAppContentFile from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MobileAppContentFile> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the MobileAppContentFile from the service
     *
     * @return the MobileAppContentFile from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MobileAppContentFile get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MobileAppContentFile> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public MobileAppContentFile delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this MobileAppContentFile with a source
     *
     * @param sourceMobileAppContentFile the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MobileAppContentFile> patchAsync(@Nonnull final MobileAppContentFile sourceMobileAppContentFile) {
        return sendAsync(HttpMethod.PATCH, sourceMobileAppContentFile);
    }

    /**
     * Patches this MobileAppContentFile with a source
     *
     * @param sourceMobileAppContentFile the source object with updates
     * @return the updated MobileAppContentFile
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MobileAppContentFile patch(@Nonnull final MobileAppContentFile sourceMobileAppContentFile) throws ClientException {
        return send(HttpMethod.PATCH, sourceMobileAppContentFile);
    }

    /**
     * Creates a MobileAppContentFile with a new object
     *
     * @param newMobileAppContentFile the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MobileAppContentFile> postAsync(@Nonnull final MobileAppContentFile newMobileAppContentFile) {
        return sendAsync(HttpMethod.POST, newMobileAppContentFile);
    }

    /**
     * Creates a MobileAppContentFile with a new object
     *
     * @param newMobileAppContentFile the new object to create
     * @return the created MobileAppContentFile
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MobileAppContentFile post(@Nonnull final MobileAppContentFile newMobileAppContentFile) throws ClientException {
        return send(HttpMethod.POST, newMobileAppContentFile);
    }

    /**
     * Creates a MobileAppContentFile with a new object
     *
     * @param newMobileAppContentFile the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MobileAppContentFile> putAsync(@Nonnull final MobileAppContentFile newMobileAppContentFile) {
        return sendAsync(HttpMethod.PUT, newMobileAppContentFile);
    }

    /**
     * Creates a MobileAppContentFile with a new object
     *
     * @param newMobileAppContentFile the object to create/update
     * @return the created MobileAppContentFile
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MobileAppContentFile put(@Nonnull final MobileAppContentFile newMobileAppContentFile) throws ClientException {
        return send(HttpMethod.PUT, newMobileAppContentFile);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public MobileAppContentFileRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public MobileAppContentFileRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

