// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ManagedDeviceOverview;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Managed Device Overview Request.
 */
public class ManagedDeviceOverviewRequest extends BaseRequest<ManagedDeviceOverview> {
	
    /**
     * The request for the ManagedDeviceOverview
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ManagedDeviceOverviewRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ManagedDeviceOverview.class);
    }

    /**
     * Gets the ManagedDeviceOverview from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ManagedDeviceOverview> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the ManagedDeviceOverview from the service
     *
     * @return the ManagedDeviceOverview from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ManagedDeviceOverview get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ManagedDeviceOverview> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public ManagedDeviceOverview delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this ManagedDeviceOverview with a source
     *
     * @param sourceManagedDeviceOverview the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ManagedDeviceOverview> patchAsync(@Nonnull final ManagedDeviceOverview sourceManagedDeviceOverview) {
        return sendAsync(HttpMethod.PATCH, sourceManagedDeviceOverview);
    }

    /**
     * Patches this ManagedDeviceOverview with a source
     *
     * @param sourceManagedDeviceOverview the source object with updates
     * @return the updated ManagedDeviceOverview
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ManagedDeviceOverview patch(@Nonnull final ManagedDeviceOverview sourceManagedDeviceOverview) throws ClientException {
        return send(HttpMethod.PATCH, sourceManagedDeviceOverview);
    }

    /**
     * Creates a ManagedDeviceOverview with a new object
     *
     * @param newManagedDeviceOverview the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ManagedDeviceOverview> postAsync(@Nonnull final ManagedDeviceOverview newManagedDeviceOverview) {
        return sendAsync(HttpMethod.POST, newManagedDeviceOverview);
    }

    /**
     * Creates a ManagedDeviceOverview with a new object
     *
     * @param newManagedDeviceOverview the new object to create
     * @return the created ManagedDeviceOverview
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ManagedDeviceOverview post(@Nonnull final ManagedDeviceOverview newManagedDeviceOverview) throws ClientException {
        return send(HttpMethod.POST, newManagedDeviceOverview);
    }

    /**
     * Creates a ManagedDeviceOverview with a new object
     *
     * @param newManagedDeviceOverview the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ManagedDeviceOverview> putAsync(@Nonnull final ManagedDeviceOverview newManagedDeviceOverview) {
        return sendAsync(HttpMethod.PUT, newManagedDeviceOverview);
    }

    /**
     * Creates a ManagedDeviceOverview with a new object
     *
     * @param newManagedDeviceOverview the object to create/update
     * @return the created ManagedDeviceOverview
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ManagedDeviceOverview put(@Nonnull final ManagedDeviceOverview newManagedDeviceOverview) throws ClientException {
        return send(HttpMethod.PUT, newManagedDeviceOverview);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public ManagedDeviceOverviewRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public ManagedDeviceOverviewRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

