// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.EducationSubmission;
import com.microsoft.graph.requests.EducationOutcomeCollectionRequestBuilder;
import com.microsoft.graph.requests.EducationOutcomeRequestBuilder;
import com.microsoft.graph.requests.EducationSubmissionResourceCollectionRequestBuilder;
import com.microsoft.graph.requests.EducationSubmissionResourceRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Education Submission Request Builder.
 */
public class EducationSubmissionRequestBuilder extends BaseRequestBuilder<EducationSubmission> {

    /**
     * The request builder for the EducationSubmission
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public EducationSubmissionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the EducationSubmissionRequest instance
     */
    @Nonnull
    public EducationSubmissionRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the EducationSubmissionRequest instance
     */
    @Nonnull
    public EducationSubmissionRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.requests.EducationSubmissionRequest(getRequestUrl(), getClient(), requestOptions);
    }


    /**
     *  Gets a request builder for the EducationOutcome collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public EducationOutcomeCollectionRequestBuilder outcomes() {
        return new EducationOutcomeCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("outcomes"), getClient(), null);
    }

    /**
     * Gets a request builder for the EducationOutcome item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public EducationOutcomeRequestBuilder outcomes(@Nonnull final String id) {
        return new EducationOutcomeRequestBuilder(getRequestUrlWithAdditionalSegment("outcomes") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the EducationSubmissionResource collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public EducationSubmissionResourceCollectionRequestBuilder resources() {
        return new EducationSubmissionResourceCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("resources"), getClient(), null);
    }

    /**
     * Gets a request builder for the EducationSubmissionResource item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public EducationSubmissionResourceRequestBuilder resources(@Nonnull final String id) {
        return new EducationSubmissionResourceRequestBuilder(getRequestUrlWithAdditionalSegment("resources") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the EducationSubmissionResource collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public EducationSubmissionResourceCollectionRequestBuilder submittedResources() {
        return new EducationSubmissionResourceCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("submittedResources"), getClient(), null);
    }

    /**
     * Gets a request builder for the EducationSubmissionResource item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public EducationSubmissionResourceRequestBuilder submittedResources(@Nonnull final String id) {
        return new EducationSubmissionResourceRequestBuilder(getRequestUrlWithAdditionalSegment("submittedResources") + "/" + id, getClient(), null);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     */
    @Nonnull
    public EducationSubmissionReturnRequestBuilder msgraphReturn() {
        return new EducationSubmissionReturnRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.return"), getClient(), null);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     */
    @Nonnull
    public EducationSubmissionSubmitRequestBuilder submit() {
        return new EducationSubmissionSubmitRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.submit"), getClient(), null);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     */
    @Nonnull
    public EducationSubmissionUnsubmitRequestBuilder unsubmit() {
        return new EducationSubmissionUnsubmitRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.unsubmit"), getClient(), null);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     */
    @Nonnull
    public EducationSubmissionSetUpResourcesFolderRequestBuilder setUpResourcesFolder() {
        return new EducationSubmissionSetUpResourcesFolderRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.setUpResourcesFolder"), getClient(), null);
    }
}
