// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ConversationMember;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Conversation Member Request.
 */
public class ConversationMemberRequest extends BaseRequest<ConversationMember> {
	
    /**
     * The request for the ConversationMember
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param responseClass  the class of the response
     */
    public ConversationMemberRequest(@Nonnull final String requestUrl,
            @Nonnull final IBaseClient<?> client,
            @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions,
            @Nonnull final Class<? extends ConversationMember> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * The request for the ConversationMember
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ConversationMemberRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ConversationMember.class);
    }

    /**
     * Gets the ConversationMember from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ConversationMember> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the ConversationMember from the service
     *
     * @return the ConversationMember from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ConversationMember get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ConversationMember> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public ConversationMember delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this ConversationMember with a source
     *
     * @param sourceConversationMember the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ConversationMember> patchAsync(@Nonnull final ConversationMember sourceConversationMember) {
        return sendAsync(HttpMethod.PATCH, sourceConversationMember);
    }

    /**
     * Patches this ConversationMember with a source
     *
     * @param sourceConversationMember the source object with updates
     * @return the updated ConversationMember
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ConversationMember patch(@Nonnull final ConversationMember sourceConversationMember) throws ClientException {
        return send(HttpMethod.PATCH, sourceConversationMember);
    }

    /**
     * Creates a ConversationMember with a new object
     *
     * @param newConversationMember the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ConversationMember> postAsync(@Nonnull final ConversationMember newConversationMember) {
        return sendAsync(HttpMethod.POST, newConversationMember);
    }

    /**
     * Creates a ConversationMember with a new object
     *
     * @param newConversationMember the new object to create
     * @return the created ConversationMember
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ConversationMember post(@Nonnull final ConversationMember newConversationMember) throws ClientException {
        return send(HttpMethod.POST, newConversationMember);
    }

    /**
     * Creates a ConversationMember with a new object
     *
     * @param newConversationMember the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ConversationMember> putAsync(@Nonnull final ConversationMember newConversationMember) {
        return sendAsync(HttpMethod.PUT, newConversationMember);
    }

    /**
     * Creates a ConversationMember with a new object
     *
     * @param newConversationMember the object to create/update
     * @return the created ConversationMember
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ConversationMember put(@Nonnull final ConversationMember newConversationMember) throws ClientException {
        return send(HttpMethod.PUT, newConversationMember);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public ConversationMemberRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public ConversationMemberRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

