// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.WorkbookIcon;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Sort Field.
 */
public class WorkbookSortField implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Ascending.
     * Represents whether the sorting is done in an ascending fashion.
     */
    @SerializedName(value = "ascending", alternate = {"Ascending"})
    @Expose
	@Nullable
    public Boolean ascending;

    /**
     * The Color.
     * Represents the color that is the target of the condition if the sorting is on font or cell color.
     */
    @SerializedName(value = "color", alternate = {"Color"})
    @Expose
	@Nullable
    public String color;

    /**
     * The Data Option.
     * Represents additional sorting options for this field. Possible values are: Normal, TextAsNumber.
     */
    @SerializedName(value = "dataOption", alternate = {"DataOption"})
    @Expose
	@Nullable
    public String dataOption;

    /**
     * The Icon.
     * Represents the icon that is the target of the condition if the sorting is on the cell's icon.
     */
    @SerializedName(value = "icon", alternate = {"Icon"})
    @Expose
	@Nullable
    public WorkbookIcon icon;

    /**
     * The Key.
     * Represents the column (or row, depending on the sort orientation) that the condition is on. Represented as an offset from the first column (or row).
     */
    @SerializedName(value = "key", alternate = {"Key"})
    @Expose
	@Nullable
    public Integer key;

    /**
     * The Sort On.
     * Represents the type of sorting of this condition. Possible values are: Value, CellColor, FontColor, Icon.
     */
    @SerializedName(value = "sortOn", alternate = {"SortOn"})
    @Expose
	@Nullable
    public String sortOn;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
