// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.WorkbookNamedItem;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Named Item Add Formula Local Parameter Set.
 */
public class WorkbookNamedItemAddFormulaLocalParameterSet {
    /**
     * The name.
     * 
     */
    @SerializedName(value = "name", alternate = {"Name"})
    @Expose
	@Nullable
    public String name;

    /**
     * The formula.
     * 
     */
    @SerializedName(value = "formula", alternate = {"Formula"})
    @Expose
	@Nullable
    public String formula;

    /**
     * The comment.
     * 
     */
    @SerializedName(value = "comment", alternate = {"Comment"})
    @Expose
	@Nullable
    public String comment;


    /**
     * Instiaciates a new WorkbookNamedItemAddFormulaLocalParameterSet
     */
    public WorkbookNamedItemAddFormulaLocalParameterSet() {}
    /**
     * Instiaciates a new WorkbookNamedItemAddFormulaLocalParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WorkbookNamedItemAddFormulaLocalParameterSet(@Nonnull final WorkbookNamedItemAddFormulaLocalParameterSetBuilder builder) {
        this.name = builder.name;
        this.formula = builder.formula;
        this.comment = builder.comment;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WorkbookNamedItemAddFormulaLocalParameterSetBuilder newBuilder() {
        return new WorkbookNamedItemAddFormulaLocalParameterSetBuilder();
    }
    /**
     * Fluent builder for the WorkbookNamedItemAddFormulaLocalParameterSet
     */
    public static final class WorkbookNamedItemAddFormulaLocalParameterSetBuilder {
        /**
         * The name parameter value
         */
        @Nullable
        protected String name;
        /**
         * Sets the Name
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookNamedItemAddFormulaLocalParameterSetBuilder withName(@Nullable final String val) {
            this.name = val;
            return this;
        }
        /**
         * The formula parameter value
         */
        @Nullable
        protected String formula;
        /**
         * Sets the Formula
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookNamedItemAddFormulaLocalParameterSetBuilder withFormula(@Nullable final String val) {
            this.formula = val;
            return this;
        }
        /**
         * The comment parameter value
         */
        @Nullable
        protected String comment;
        /**
         * Sets the Comment
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookNamedItemAddFormulaLocalParameterSetBuilder withComment(@Nullable final String val) {
            this.comment = val;
            return this;
        }
        /**
         * Instanciates a new WorkbookNamedItemAddFormulaLocalParameterSetBuilder
         */
        @Nullable
        protected WorkbookNamedItemAddFormulaLocalParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WorkbookNamedItemAddFormulaLocalParameterSet build() {
            return new WorkbookNamedItemAddFormulaLocalParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.name != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("name", name));
        }
        if(this.formula != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("formula", formula));
        }
        if(this.comment != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("comment", comment));
        }
        return result;
    }
}
