// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.WorkbookFunctionResult;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Functions Unicode Parameter Set.
 */
public class WorkbookFunctionsUnicodeParameterSet {
    /**
     * The text.
     * 
     */
    @SerializedName(value = "text", alternate = {"Text"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement text;


    /**
     * Instiaciates a new WorkbookFunctionsUnicodeParameterSet
     */
    public WorkbookFunctionsUnicodeParameterSet() {}
    /**
     * Instiaciates a new WorkbookFunctionsUnicodeParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WorkbookFunctionsUnicodeParameterSet(@Nonnull final WorkbookFunctionsUnicodeParameterSetBuilder builder) {
        this.text = builder.text;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WorkbookFunctionsUnicodeParameterSetBuilder newBuilder() {
        return new WorkbookFunctionsUnicodeParameterSetBuilder();
    }
    /**
     * Fluent builder for the WorkbookFunctionsUnicodeParameterSet
     */
    public static final class WorkbookFunctionsUnicodeParameterSetBuilder {
        /**
         * The text parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement text;
        /**
         * Sets the Text
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsUnicodeParameterSetBuilder withText(@Nullable final com.google.gson.JsonElement val) {
            this.text = val;
            return this;
        }
        /**
         * Instanciates a new WorkbookFunctionsUnicodeParameterSetBuilder
         */
        @Nullable
        protected WorkbookFunctionsUnicodeParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WorkbookFunctionsUnicodeParameterSet build() {
            return new WorkbookFunctionsUnicodeParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.text != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("text", text));
        }
        return result;
    }
}
