// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.WorkbookFunctionResult;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Functions Effect Parameter Set.
 */
public class WorkbookFunctionsEffectParameterSet {
    /**
     * The nominal Rate.
     * 
     */
    @SerializedName(value = "nominalRate", alternate = {"NominalRate"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement nominalRate;

    /**
     * The npery.
     * 
     */
    @SerializedName(value = "npery", alternate = {"Npery"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement npery;


    /**
     * Instiaciates a new WorkbookFunctionsEffectParameterSet
     */
    public WorkbookFunctionsEffectParameterSet() {}
    /**
     * Instiaciates a new WorkbookFunctionsEffectParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WorkbookFunctionsEffectParameterSet(@Nonnull final WorkbookFunctionsEffectParameterSetBuilder builder) {
        this.nominalRate = builder.nominalRate;
        this.npery = builder.npery;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WorkbookFunctionsEffectParameterSetBuilder newBuilder() {
        return new WorkbookFunctionsEffectParameterSetBuilder();
    }
    /**
     * Fluent builder for the WorkbookFunctionsEffectParameterSet
     */
    public static final class WorkbookFunctionsEffectParameterSetBuilder {
        /**
         * The nominalRate parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement nominalRate;
        /**
         * Sets the NominalRate
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsEffectParameterSetBuilder withNominalRate(@Nullable final com.google.gson.JsonElement val) {
            this.nominalRate = val;
            return this;
        }
        /**
         * The npery parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement npery;
        /**
         * Sets the Npery
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsEffectParameterSetBuilder withNpery(@Nullable final com.google.gson.JsonElement val) {
            this.npery = val;
            return this;
        }
        /**
         * Instanciates a new WorkbookFunctionsEffectParameterSetBuilder
         */
        @Nullable
        protected WorkbookFunctionsEffectParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WorkbookFunctionsEffectParameterSet build() {
            return new WorkbookFunctionsEffectParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.nominalRate != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("nominalRate", nominalRate));
        }
        if(this.npery != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("npery", npery));
        }
        return result;
    }
}
