// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.Reminder;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the User Reminder View Parameter Set.
 */
public class UserReminderViewParameterSet {
    /**
     * The start Date Time.
     * 
     */
    @SerializedName(value = "startDateTime", alternate = {"StartDateTime"})
    @Expose
	@Nullable
    public String startDateTime;

    /**
     * The end Date Time.
     * 
     */
    @SerializedName(value = "endDateTime", alternate = {"EndDateTime"})
    @Expose
	@Nullable
    public String endDateTime;


    /**
     * Instiaciates a new UserReminderViewParameterSet
     */
    public UserReminderViewParameterSet() {}
    /**
     * Instiaciates a new UserReminderViewParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected UserReminderViewParameterSet(@Nonnull final UserReminderViewParameterSetBuilder builder) {
        this.startDateTime = builder.startDateTime;
        this.endDateTime = builder.endDateTime;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static UserReminderViewParameterSetBuilder newBuilder() {
        return new UserReminderViewParameterSetBuilder();
    }
    /**
     * Fluent builder for the UserReminderViewParameterSet
     */
    public static final class UserReminderViewParameterSetBuilder {
        /**
         * The startDateTime parameter value
         */
        @Nullable
        protected String startDateTime;
        /**
         * Sets the StartDateTime
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public UserReminderViewParameterSetBuilder withStartDateTime(@Nullable final String val) {
            this.startDateTime = val;
            return this;
        }
        /**
         * The endDateTime parameter value
         */
        @Nullable
        protected String endDateTime;
        /**
         * Sets the EndDateTime
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public UserReminderViewParameterSetBuilder withEndDateTime(@Nullable final String val) {
            this.endDateTime = val;
            return this;
        }
        /**
         * Instanciates a new UserReminderViewParameterSetBuilder
         */
        @Nullable
        protected UserReminderViewParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public UserReminderViewParameterSet build() {
            return new UserReminderViewParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.startDateTime != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("startDateTime", startDateTime));
        }
        if(this.endDateTime != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("endDateTime", endDateTime));
        }
        return result;
    }
}
