// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Lookup Column.
 */
public class LookupColumn implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Allow Multiple Values.
     * Indicates whether multiple values can be selected from the source.
     */
    @SerializedName(value = "allowMultipleValues", alternate = {"AllowMultipleValues"})
    @Expose
	@Nullable
    public Boolean allowMultipleValues;

    /**
     * The Allow Unlimited Length.
     * Indicates whether values in the column should be able to exceed the standard limit of 255 characters.
     */
    @SerializedName(value = "allowUnlimitedLength", alternate = {"AllowUnlimitedLength"})
    @Expose
	@Nullable
    public Boolean allowUnlimitedLength;

    /**
     * The Column Name.
     * The name of the lookup source column.
     */
    @SerializedName(value = "columnName", alternate = {"ColumnName"})
    @Expose
	@Nullable
    public String columnName;

    /**
     * The List Id.
     * The unique identifier of the lookup source list.
     */
    @SerializedName(value = "listId", alternate = {"ListId"})
    @Expose
	@Nullable
    public String listId;

    /**
     * The Primary Lookup Column Id.
     * If specified, this column is a secondary lookup, pulling an additional field from the list item looked up by the primary lookup. Use the list item looked up by the primary as the source for the column named here.
     */
    @SerializedName(value = "primaryLookupColumnId", alternate = {"PrimaryLookupColumnId"})
    @Expose
	@Nullable
    public String primaryLookupColumnId;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
