// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.PhysicalAddress;
import com.microsoft.graph.models.OutlookGeoCoordinates;
import com.microsoft.graph.models.LocationType;
import com.microsoft.graph.models.LocationUniqueIdType;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Location.
 */
public class Location implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Address.
     * The street address of the location.
     */
    @SerializedName(value = "address", alternate = {"Address"})
    @Expose
	@Nullable
    public PhysicalAddress address;

    /**
     * The Coordinates.
     * The geographic coordinates and elevation of the location.
     */
    @SerializedName(value = "coordinates", alternate = {"Coordinates"})
    @Expose
	@Nullable
    public OutlookGeoCoordinates coordinates;

    /**
     * The Display Name.
     * The name associated with the location.
     */
    @SerializedName(value = "displayName", alternate = {"DisplayName"})
    @Expose
	@Nullable
    public String displayName;

    /**
     * The Location Email Address.
     * Optional email address of the location.
     */
    @SerializedName(value = "locationEmailAddress", alternate = {"LocationEmailAddress"})
    @Expose
	@Nullable
    public String locationEmailAddress;

    /**
     * The Location Type.
     * The type of location. Possible values are: default, conferenceRoom, homeAddress, businessAddress,geoCoordinates, streetAddress, hotel, restaurant, localBusiness, postalAddress. Read-only.
     */
    @SerializedName(value = "locationType", alternate = {"LocationType"})
    @Expose
	@Nullable
    public LocationType locationType;

    /**
     * The Location Uri.
     * Optional URI representing the location.
     */
    @SerializedName(value = "locationUri", alternate = {"LocationUri"})
    @Expose
	@Nullable
    public String locationUri;

    /**
     * The Unique Id.
     * For internal use only.
     */
    @SerializedName(value = "uniqueId", alternate = {"UniqueId"})
    @Expose
	@Nullable
    public String uniqueId;

    /**
     * The Unique Id Type.
     * For internal use only.
     */
    @SerializedName(value = "uniqueIdType", alternate = {"UniqueIdType"})
    @Expose
	@Nullable
    public LocationUniqueIdType uniqueIdType;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
