// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.ConditionalAccessRoot;
import com.microsoft.graph.models.IdentityApiConnector;
import com.microsoft.graph.models.B2xIdentityUserFlow;
import com.microsoft.graph.models.IdentityProviderBase;
import com.microsoft.graph.models.IdentityUserFlowAttribute;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.requests.IdentityApiConnectorCollectionPage;
import com.microsoft.graph.requests.B2xIdentityUserFlowCollectionPage;
import com.microsoft.graph.requests.IdentityProviderBaseCollectionPage;
import com.microsoft.graph.requests.IdentityUserFlowAttributeCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Identity Container.
 */
public class IdentityContainer extends Entity implements IJsonBackedObject {


    /**
     * The Conditional Access.
     * 
     */
    @SerializedName(value = "conditionalAccess", alternate = {"ConditionalAccess"})
    @Expose
	@Nullable
    public ConditionalAccessRoot conditionalAccess;

    /**
     * The Api Connectors.
     * 
     */
    @SerializedName(value = "apiConnectors", alternate = {"ApiConnectors"})
    @Expose
	@Nullable
    public IdentityApiConnectorCollectionPage apiConnectors;

    /**
     * The B2x User Flows.
     * 
     */
    @SerializedName(value = "b2xUserFlows", alternate = {"B2xUserFlows"})
    @Expose
	@Nullable
    public B2xIdentityUserFlowCollectionPage b2xUserFlows;

    /**
     * The Identity Providers.
     * 
     */
    @SerializedName(value = "identityProviders", alternate = {"IdentityProviders"})
    @Expose
	@Nullable
    public IdentityProviderBaseCollectionPage identityProviders;

    /**
     * The User Flow Attributes.
     * 
     */
    @SerializedName(value = "userFlowAttributes", alternate = {"UserFlowAttributes"})
    @Expose
	@Nullable
    public IdentityUserFlowAttributeCollectionPage userFlowAttributes;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("apiConnectors")) {
            apiConnectors = serializer.deserializeObject(json.get("apiConnectors"), IdentityApiConnectorCollectionPage.class);
        }

        if (json.has("b2xUserFlows")) {
            b2xUserFlows = serializer.deserializeObject(json.get("b2xUserFlows"), B2xIdentityUserFlowCollectionPage.class);
        }

        if (json.has("identityProviders")) {
            identityProviders = serializer.deserializeObject(json.get("identityProviders"), IdentityProviderBaseCollectionPage.class);
        }

        if (json.has("userFlowAttributes")) {
            userFlowAttributes = serializer.deserializeObject(json.get("userFlowAttributes"), IdentityUserFlowAttributeCollectionPage.class);
        }
    }
}
