// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.DriveItemUploadableProperties;
import com.microsoft.graph.models.UploadSession;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Drive Item Create Upload Session Parameter Set.
 */
public class DriveItemCreateUploadSessionParameterSet {
    /**
     * The item.
     * 
     */
    @SerializedName(value = "item", alternate = {"Item"})
    @Expose
	@Nullable
    public DriveItemUploadableProperties item;


    /**
     * Instiaciates a new DriveItemCreateUploadSessionParameterSet
     */
    public DriveItemCreateUploadSessionParameterSet() {}
    /**
     * Instiaciates a new DriveItemCreateUploadSessionParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected DriveItemCreateUploadSessionParameterSet(@Nonnull final DriveItemCreateUploadSessionParameterSetBuilder builder) {
        this.item = builder.item;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static DriveItemCreateUploadSessionParameterSetBuilder newBuilder() {
        return new DriveItemCreateUploadSessionParameterSetBuilder();
    }
    /**
     * Fluent builder for the DriveItemCreateUploadSessionParameterSet
     */
    public static final class DriveItemCreateUploadSessionParameterSetBuilder {
        /**
         * The item parameter value
         */
        @Nullable
        protected DriveItemUploadableProperties item;
        /**
         * Sets the Item
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public DriveItemCreateUploadSessionParameterSetBuilder withItem(@Nullable final DriveItemUploadableProperties val) {
            this.item = val;
            return this;
        }
        /**
         * Instanciates a new DriveItemCreateUploadSessionParameterSetBuilder
         */
        @Nullable
        protected DriveItemCreateUploadSessionParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public DriveItemCreateUploadSessionParameterSet build() {
            return new DriveItemCreateUploadSessionParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.item != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("item", item));
        }
        return result;
    }
}
