// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.DirectoryObject;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Directory Object Partner Reference.
 */
public class DirectoryObjectPartnerReference extends DirectoryObject implements IJsonBackedObject {


    /**
     * The Description.
     * Description of the object returned. Read-only.
     */
    @SerializedName(value = "description", alternate = {"Description"})
    @Expose
	@Nullable
    public String description;

    /**
     * The Display Name.
     * Name of directory object being returned, like group or application. Read-only.
     */
    @SerializedName(value = "displayName", alternate = {"DisplayName"})
    @Expose
	@Nullable
    public String displayName;

    /**
     * The External Partner Tenant Id.
     * The tenant identifier for the partner tenant. Read-only.
     */
    @SerializedName(value = "externalPartnerTenantId", alternate = {"ExternalPartnerTenantId"})
    @Expose
	@Nullable
    public java.util.UUID externalPartnerTenantId;

    /**
     * The Object Type.
     * The type of the referenced object in the partner tenant. Read-only.
     */
    @SerializedName(value = "objectType", alternate = {"ObjectType"})
    @Expose
	@Nullable
    public String objectType;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
