// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.DirectoryObject;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Directory Object Get By Ids Parameter Set.
 */
public class DirectoryObjectGetByIdsParameterSet {
    /**
     * The ids.
     * 
     */
    @SerializedName(value = "ids", alternate = {"Ids"})
    @Expose
	@Nullable
    public java.util.List<String> ids;

    /**
     * The types.
     * 
     */
    @SerializedName(value = "types", alternate = {"Types"})
    @Expose
	@Nullable
    public java.util.List<String> types;


    /**
     * Instiaciates a new DirectoryObjectGetByIdsParameterSet
     */
    public DirectoryObjectGetByIdsParameterSet() {}
    /**
     * Instiaciates a new DirectoryObjectGetByIdsParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected DirectoryObjectGetByIdsParameterSet(@Nonnull final DirectoryObjectGetByIdsParameterSetBuilder builder) {
        this.ids = builder.ids;
        this.types = builder.types;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static DirectoryObjectGetByIdsParameterSetBuilder newBuilder() {
        return new DirectoryObjectGetByIdsParameterSetBuilder();
    }
    /**
     * Fluent builder for the DirectoryObjectGetByIdsParameterSet
     */
    public static final class DirectoryObjectGetByIdsParameterSetBuilder {
        /**
         * The ids parameter value
         */
        @Nullable
        protected java.util.List<String> ids;
        /**
         * Sets the Ids
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public DirectoryObjectGetByIdsParameterSetBuilder withIds(@Nullable final java.util.List<String> val) {
            this.ids = val;
            return this;
        }
        /**
         * The types parameter value
         */
        @Nullable
        protected java.util.List<String> types;
        /**
         * Sets the Types
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public DirectoryObjectGetByIdsParameterSetBuilder withTypes(@Nullable final java.util.List<String> val) {
            this.types = val;
            return this;
        }
        /**
         * Instanciates a new DirectoryObjectGetByIdsParameterSetBuilder
         */
        @Nullable
        protected DirectoryObjectGetByIdsParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public DirectoryObjectGetByIdsParameterSet build() {
            return new DirectoryObjectGetByIdsParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.ids != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("ids", ids));
        }
        if(this.types != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("types", types));
        }
        return result;
    }
}
