// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.AgreementAcceptanceState;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Agreement Acceptance.
 */
public class AgreementAcceptance extends Entity implements IJsonBackedObject {


    /**
     * The Agreement File Id.
     * ID of the agreement file accepted by the user.
     */
    @SerializedName(value = "agreementFileId", alternate = {"AgreementFileId"})
    @Expose
	@Nullable
    public String agreementFileId;

    /**
     * The Agreement Id.
     * ID of the agreement.
     */
    @SerializedName(value = "agreementId", alternate = {"AgreementId"})
    @Expose
	@Nullable
    public String agreementId;

    /**
     * The Device Display Name.
     * The display name of the device used for accepting the agreement.
     */
    @SerializedName(value = "deviceDisplayName", alternate = {"DeviceDisplayName"})
    @Expose
	@Nullable
    public String deviceDisplayName;

    /**
     * The Device Id.
     * The unique identifier of the device used for accepting the agreement.
     */
    @SerializedName(value = "deviceId", alternate = {"DeviceId"})
    @Expose
	@Nullable
    public String deviceId;

    /**
     * The Device OSType.
     * The operating system used for accepting the agreement.
     */
    @SerializedName(value = "deviceOSType", alternate = {"DeviceOSType"})
    @Expose
	@Nullable
    public String deviceOSType;

    /**
     * The Device OSVersion.
     * The operating system version of the device used for accepting the agreement.
     */
    @SerializedName(value = "deviceOSVersion", alternate = {"DeviceOSVersion"})
    @Expose
	@Nullable
    public String deviceOSVersion;

    /**
     * The Expiration Date Time.
     * The expiration date time of the acceptance. The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z
     */
    @SerializedName(value = "expirationDateTime", alternate = {"ExpirationDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime expirationDateTime;

    /**
     * The Recorded Date Time.
     * The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z
     */
    @SerializedName(value = "recordedDateTime", alternate = {"RecordedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime recordedDateTime;

    /**
     * The State.
     * Possible values are: accepted, declined.
     */
    @SerializedName(value = "state", alternate = {"State"})
    @Expose
	@Nullable
    public AgreementAcceptanceState state;

    /**
     * The User Display Name.
     * Display name of the user when the acceptance was recorded.
     */
    @SerializedName(value = "userDisplayName", alternate = {"UserDisplayName"})
    @Expose
	@Nullable
    public String userDisplayName;

    /**
     * The User Email.
     * Email of the user when the acceptance was recorded.
     */
    @SerializedName(value = "userEmail", alternate = {"UserEmail"})
    @Expose
	@Nullable
    public String userEmail;

    /**
     * The User Id.
     * ID of the user who accepted the agreement.
     */
    @SerializedName(value = "userId", alternate = {"UserId"})
    @Expose
	@Nullable
    public String userId;

    /**
     * The User Principal Name.
     * UPN of the user when the acceptance was recorded.
     */
    @SerializedName(value = "userPrincipalName", alternate = {"UserPrincipalName"})
    @Expose
	@Nullable
    public String userPrincipalName;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
