// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.Request;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Request Request.
 */
public class RequestRequest extends BaseRequest<Request> {
	
    /**
     * The request for the Request
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param responseClass  the class of the response
     */
    public RequestRequest(@Nonnull final String requestUrl,
            @Nonnull final IBaseClient<?> client,
            @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions,
            @Nonnull final Class<? extends Request> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * The request for the Request
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public RequestRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, Request.class);
    }

    /**
     * Gets the Request from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Request> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the Request from the service
     *
     * @return the Request from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Request get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Request> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public Request delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this Request with a source
     *
     * @param sourceRequest the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Request> patchAsync(@Nonnull final Request sourceRequest) {
        return sendAsync(HttpMethod.PATCH, sourceRequest);
    }

    /**
     * Patches this Request with a source
     *
     * @param sourceRequest the source object with updates
     * @return the updated Request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Request patch(@Nonnull final Request sourceRequest) throws ClientException {
        return send(HttpMethod.PATCH, sourceRequest);
    }

    /**
     * Creates a Request with a new object
     *
     * @param newRequest the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Request> postAsync(@Nonnull final Request newRequest) {
        return sendAsync(HttpMethod.POST, newRequest);
    }

    /**
     * Creates a Request with a new object
     *
     * @param newRequest the new object to create
     * @return the created Request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Request post(@Nonnull final Request newRequest) throws ClientException {
        return send(HttpMethod.POST, newRequest);
    }

    /**
     * Creates a Request with a new object
     *
     * @param newRequest the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Request> putAsync(@Nonnull final Request newRequest) {
        return sendAsync(HttpMethod.PUT, newRequest);
    }

    /**
     * Creates a Request with a new object
     *
     * @param newRequest the object to create/update
     * @return the created Request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Request put(@Nonnull final Request newRequest) throws ClientException {
        return send(HttpMethod.PUT, newRequest);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public RequestRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public RequestRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

