// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.MacOSGeneralDeviceConfiguration;
import com.microsoft.graph.models.DeviceConfigurationAssignment;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Mac OSGeneral Device Configuration Request.
 */
public class MacOSGeneralDeviceConfigurationRequest extends BaseRequest<MacOSGeneralDeviceConfiguration> {
	
    /**
     * The request for the MacOSGeneralDeviceConfiguration
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public MacOSGeneralDeviceConfigurationRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, MacOSGeneralDeviceConfiguration.class);
    }

    /**
     * Gets the MacOSGeneralDeviceConfiguration from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MacOSGeneralDeviceConfiguration> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the MacOSGeneralDeviceConfiguration from the service
     *
     * @return the MacOSGeneralDeviceConfiguration from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MacOSGeneralDeviceConfiguration get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MacOSGeneralDeviceConfiguration> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public MacOSGeneralDeviceConfiguration delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this MacOSGeneralDeviceConfiguration with a source
     *
     * @param sourceMacOSGeneralDeviceConfiguration the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MacOSGeneralDeviceConfiguration> patchAsync(@Nonnull final MacOSGeneralDeviceConfiguration sourceMacOSGeneralDeviceConfiguration) {
        return sendAsync(HttpMethod.PATCH, sourceMacOSGeneralDeviceConfiguration);
    }

    /**
     * Patches this MacOSGeneralDeviceConfiguration with a source
     *
     * @param sourceMacOSGeneralDeviceConfiguration the source object with updates
     * @return the updated MacOSGeneralDeviceConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MacOSGeneralDeviceConfiguration patch(@Nonnull final MacOSGeneralDeviceConfiguration sourceMacOSGeneralDeviceConfiguration) throws ClientException {
        return send(HttpMethod.PATCH, sourceMacOSGeneralDeviceConfiguration);
    }

    /**
     * Creates a MacOSGeneralDeviceConfiguration with a new object
     *
     * @param newMacOSGeneralDeviceConfiguration the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MacOSGeneralDeviceConfiguration> postAsync(@Nonnull final MacOSGeneralDeviceConfiguration newMacOSGeneralDeviceConfiguration) {
        return sendAsync(HttpMethod.POST, newMacOSGeneralDeviceConfiguration);
    }

    /**
     * Creates a MacOSGeneralDeviceConfiguration with a new object
     *
     * @param newMacOSGeneralDeviceConfiguration the new object to create
     * @return the created MacOSGeneralDeviceConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MacOSGeneralDeviceConfiguration post(@Nonnull final MacOSGeneralDeviceConfiguration newMacOSGeneralDeviceConfiguration) throws ClientException {
        return send(HttpMethod.POST, newMacOSGeneralDeviceConfiguration);
    }

    /**
     * Creates a MacOSGeneralDeviceConfiguration with a new object
     *
     * @param newMacOSGeneralDeviceConfiguration the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MacOSGeneralDeviceConfiguration> putAsync(@Nonnull final MacOSGeneralDeviceConfiguration newMacOSGeneralDeviceConfiguration) {
        return sendAsync(HttpMethod.PUT, newMacOSGeneralDeviceConfiguration);
    }

    /**
     * Creates a MacOSGeneralDeviceConfiguration with a new object
     *
     * @param newMacOSGeneralDeviceConfiguration the object to create/update
     * @return the created MacOSGeneralDeviceConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MacOSGeneralDeviceConfiguration put(@Nonnull final MacOSGeneralDeviceConfiguration newMacOSGeneralDeviceConfiguration) throws ClientException {
        return send(HttpMethod.PUT, newMacOSGeneralDeviceConfiguration);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public MacOSGeneralDeviceConfigurationRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public MacOSGeneralDeviceConfigurationRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

