// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.MicrosoftStoreForBusinessLicenseType;
import com.microsoft.graph.models.MobileApp;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Microsoft Store For Business App.
 */
public class MicrosoftStoreForBusinessApp extends MobileApp implements IJsonBackedObject {


    /**
     * The License Type.
     * The app license type. Possible values are: offline, online.
     */
    @SerializedName(value = "licenseType", alternate = {"LicenseType"})
    @Expose
	@Nullable
    public MicrosoftStoreForBusinessLicenseType licenseType;

    /**
     * The Package Identity Name.
     * The app package identifier
     */
    @SerializedName(value = "packageIdentityName", alternate = {"PackageIdentityName"})
    @Expose
	@Nullable
    public String packageIdentityName;

    /**
     * The Product Key.
     * The app product key
     */
    @SerializedName(value = "productKey", alternate = {"ProductKey"})
    @Expose
	@Nullable
    public String productKey;

    /**
     * The Total License Count.
     * The total number of Microsoft Store for Business licenses.
     */
    @SerializedName(value = "totalLicenseCount", alternate = {"TotalLicenseCount"})
    @Expose
	@Nullable
    public Integer totalLicenseCount;

    /**
     * The Used License Count.
     * The number of Microsoft Store for Business licenses in use.
     */
    @SerializedName(value = "usedLicenseCount", alternate = {"UsedLicenseCount"})
    @Expose
	@Nullable
    public Integer usedLicenseCount;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
