// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.EducationCourse;
import com.microsoft.graph.models.IdentitySet;
import com.microsoft.graph.models.EducationExternalSource;
import com.microsoft.graph.models.EducationTerm;
import com.microsoft.graph.models.Group;
import com.microsoft.graph.models.EducationUser;
import com.microsoft.graph.models.EducationSchool;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.requests.EducationUserCollectionPage;
import com.microsoft.graph.requests.EducationSchoolCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Education Class.
 */
public class EducationClass extends Entity implements IJsonBackedObject {


    /**
     * The Class Code.
     * Class code used by the school to identify the class.
     */
    @SerializedName(value = "classCode", alternate = {"ClassCode"})
    @Expose
	@Nullable
    public String classCode;

    /**
     * The Course.
     * Course information for the class
     */
    @SerializedName(value = "course", alternate = {"Course"})
    @Expose
	@Nullable
    public EducationCourse course;

    /**
     * The Created By.
     * Entity who created the class
     */
    @SerializedName(value = "createdBy", alternate = {"CreatedBy"})
    @Expose
	@Nullable
    public IdentitySet createdBy;

    /**
     * The Description.
     * Description of the class.
     */
    @SerializedName(value = "description", alternate = {"Description"})
    @Expose
	@Nullable
    public String description;

    /**
     * The Display Name.
     * Name of the class.
     */
    @SerializedName(value = "displayName", alternate = {"DisplayName"})
    @Expose
	@Nullable
    public String displayName;

    /**
     * The External Id.
     * ID of the class from the syncing system.
     */
    @SerializedName(value = "externalId", alternate = {"ExternalId"})
    @Expose
	@Nullable
    public String externalId;

    /**
     * The External Name.
     * Name of the class in the syncing system.
     */
    @SerializedName(value = "externalName", alternate = {"ExternalName"})
    @Expose
	@Nullable
    public String externalName;

    /**
     * The External Source.
     * The type of external source this resource was generated from (automatically determined from externalSourceDetail). Possible values are: sis, lms, or manual.
     */
    @SerializedName(value = "externalSource", alternate = {"ExternalSource"})
    @Expose
	@Nullable
    public EducationExternalSource externalSource;

    /**
     * The External Source Detail.
     * The name of the external source this resources was generated from.
     */
    @SerializedName(value = "externalSourceDetail", alternate = {"ExternalSourceDetail"})
    @Expose
	@Nullable
    public String externalSourceDetail;

    /**
     * The Grade.
     * Grade level of the class.
     */
    @SerializedName(value = "grade", alternate = {"Grade"})
    @Expose
	@Nullable
    public String grade;

    /**
     * The Mail Nickname.
     * Mail name for sending email to all members, if this is enabled.
     */
    @SerializedName(value = "mailNickname", alternate = {"MailNickname"})
    @Expose
	@Nullable
    public String mailNickname;

    /**
     * The Term.
     * Term for the class.
     */
    @SerializedName(value = "term", alternate = {"Term"})
    @Expose
	@Nullable
    public EducationTerm term;

    /**
     * The Group.
     * The directory group corresponding to this class.
     */
    @SerializedName(value = "group", alternate = {"Group"})
    @Expose
	@Nullable
    public Group group;

    /**
     * The Members.
     * All users in the class. Nullable.
     */
	@Nullable
    public EducationUserCollectionPage members;

    /**
     * The Schools.
     * All schools that this class is associated with. Nullable.
     */
	@Nullable
    public EducationSchoolCollectionPage schools;

    /**
     * The Teachers.
     * All teachers in the class. Nullable.
     */
	@Nullable
    public EducationUserCollectionPage teachers;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("members")) {
            members = serializer.deserializeObject(json.get("members"), EducationUserCollectionPage.class);
        }

        if (json.has("schools")) {
            schools = serializer.deserializeObject(json.get("schools"), EducationSchoolCollectionPage.class);
        }

        if (json.has("teachers")) {
            teachers = serializer.deserializeObject(json.get("teachers"), EducationUserCollectionPage.class);
        }
    }
}
