// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.IdentitySet;
import com.microsoft.graph.models.NotebookLinks;
import com.microsoft.graph.models.OnenoteUserRole;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Copy Notebook Model.
 */
public class CopyNotebookModel implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Created By.
     * 
     */
    @SerializedName(value = "createdBy", alternate = {"CreatedBy"})
    @Expose
	@Nullable
    public String createdBy;

    /**
     * The Created By Identity.
     * 
     */
    @SerializedName(value = "createdByIdentity", alternate = {"CreatedByIdentity"})
    @Expose
	@Nullable
    public IdentitySet createdByIdentity;

    /**
     * The Created Time.
     * 
     */
    @SerializedName(value = "createdTime", alternate = {"CreatedTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime createdTime;

    /**
     * The Id.
     * 
     */
    @SerializedName(value = "id", alternate = {"Id"})
    @Expose
	@Nullable
    public String id;

    /**
     * The Is Default.
     * 
     */
    @SerializedName(value = "isDefault", alternate = {"IsDefault"})
    @Expose
	@Nullable
    public Boolean isDefault;

    /**
     * The Is Shared.
     * 
     */
    @SerializedName(value = "isShared", alternate = {"IsShared"})
    @Expose
	@Nullable
    public Boolean isShared;

    /**
     * The Last Modified By.
     * 
     */
    @SerializedName(value = "lastModifiedBy", alternate = {"LastModifiedBy"})
    @Expose
	@Nullable
    public String lastModifiedBy;

    /**
     * The Last Modified By Identity.
     * 
     */
    @SerializedName(value = "lastModifiedByIdentity", alternate = {"LastModifiedByIdentity"})
    @Expose
	@Nullable
    public IdentitySet lastModifiedByIdentity;

    /**
     * The Last Modified Time.
     * 
     */
    @SerializedName(value = "lastModifiedTime", alternate = {"LastModifiedTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime lastModifiedTime;

    /**
     * The Links.
     * 
     */
    @SerializedName(value = "links", alternate = {"Links"})
    @Expose
	@Nullable
    public NotebookLinks links;

    /**
     * The Name.
     * 
     */
    @SerializedName(value = "name", alternate = {"Name"})
    @Expose
	@Nullable
    public String name;

    /**
     * The Section Groups Url.
     * 
     */
    @SerializedName(value = "sectionGroupsUrl", alternate = {"SectionGroupsUrl"})
    @Expose
	@Nullable
    public String sectionGroupsUrl;

    /**
     * The Sections Url.
     * 
     */
    @SerializedName(value = "sectionsUrl", alternate = {"SectionsUrl"})
    @Expose
	@Nullable
    public String sectionsUrl;

    /**
     * The Self.
     * 
     */
    @SerializedName(value = "self", alternate = {"Self"})
    @Expose
	@Nullable
    public String self;

    /**
     * The User Role.
     * 
     */
    @SerializedName(value = "userRole", alternate = {"UserRole"})
    @Expose
	@Nullable
    public OnenoteUserRole userRole;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
