// Template Source: BaseEntityCollectionRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.CloudCommunications;
import com.microsoft.graph.models.Call;
import com.microsoft.graph.models.InvitationParticipantInfo;
import com.microsoft.graph.models.MediaConfig;
import com.microsoft.graph.models.Modality;
import com.microsoft.graph.models.CancelMediaProcessingOperation;
import com.microsoft.graph.models.ScreenSharingRole;
import com.microsoft.graph.models.MuteParticipantOperation;
import com.microsoft.graph.models.Prompt;
import com.microsoft.graph.models.PlayPromptOperation;
import com.microsoft.graph.models.RecordOperation;
import com.microsoft.graph.models.RejectReason;
import com.microsoft.graph.models.SubscribeToToneOperation;
import com.microsoft.graph.models.UnmuteParticipantOperation;
import com.microsoft.graph.models.RecordingStatus;
import com.microsoft.graph.models.UpdateRecordingStatusOperation;
import com.microsoft.graph.models.TeleconferenceDeviceQuality;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.CallCollectionRequestBuilder;
import com.microsoft.graph.requests.CallRequestBuilder;
import com.microsoft.graph.requests.CallCollectionRequest;
import com.microsoft.graph.requests.CallLogTeleconferenceDeviceQualityRequestBuilder;
import com.microsoft.graph.http.BaseCollectionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.PrimitiveRequestBuilder;
import com.microsoft.graph.models.CallRedirectParameterSet;
import com.microsoft.graph.models.CallAnswerParameterSet;
import com.microsoft.graph.models.CallCancelMediaProcessingParameterSet;
import com.microsoft.graph.models.CallChangeScreenSharingRoleParameterSet;
import com.microsoft.graph.models.CallMuteParameterSet;
import com.microsoft.graph.models.CallPlayPromptParameterSet;
import com.microsoft.graph.models.CallRecordResponseParameterSet;
import com.microsoft.graph.models.CallRejectParameterSet;
import com.microsoft.graph.models.CallSubscribeToToneParameterSet;
import com.microsoft.graph.models.CallTransferParameterSet;
import com.microsoft.graph.models.CallUnmuteParameterSet;
import com.microsoft.graph.models.CallUpdateRecordingStatusParameterSet;
import com.microsoft.graph.models.CallLogTeleconferenceDeviceQualityParameterSet;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Call Collection Request Builder.
 */
public class CallCollectionRequestBuilder extends BaseCollectionRequestBuilder<Call, CallRequestBuilder, CallCollectionResponse, CallCollectionPage, CallCollectionRequest> {

    /**
     * The request builder for this collection of CloudCommunications
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public CallCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, CallRequestBuilder.class, CallCollectionRequest.class);
    }



    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public CallLogTeleconferenceDeviceQualityRequestBuilder logTeleconferenceDeviceQuality(@Nonnull final CallLogTeleconferenceDeviceQualityParameterSet parameters) {
        return new CallLogTeleconferenceDeviceQualityRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.logTeleconferenceDeviceQuality"), getClient(), null, parameters);
    }

    /**
     * Gets the raw count request for the collection
     * @return The raw count request for the collection
     */
    @Nonnull
    public PrimitiveRequestBuilder<Long> count() {
        return new PrimitiveRequestBuilder<Long>(getRequestUrlWithAdditionalSegment("$count"), getClient(), null, Long.class);
    }
}
