// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.AgreementFileVersion;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Agreement File Version Request.
 */
public class AgreementFileVersionRequest extends BaseRequest<AgreementFileVersion> {
	
    /**
     * The request for the AgreementFileVersion
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AgreementFileVersionRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AgreementFileVersion.class);
    }

    /**
     * Gets the AgreementFileVersion from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AgreementFileVersion> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the AgreementFileVersion from the service
     *
     * @return the AgreementFileVersion from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AgreementFileVersion get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AgreementFileVersion> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public AgreementFileVersion delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this AgreementFileVersion with a source
     *
     * @param sourceAgreementFileVersion the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AgreementFileVersion> patchAsync(@Nonnull final AgreementFileVersion sourceAgreementFileVersion) {
        return sendAsync(HttpMethod.PATCH, sourceAgreementFileVersion);
    }

    /**
     * Patches this AgreementFileVersion with a source
     *
     * @param sourceAgreementFileVersion the source object with updates
     * @return the updated AgreementFileVersion
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AgreementFileVersion patch(@Nonnull final AgreementFileVersion sourceAgreementFileVersion) throws ClientException {
        return send(HttpMethod.PATCH, sourceAgreementFileVersion);
    }

    /**
     * Creates a AgreementFileVersion with a new object
     *
     * @param newAgreementFileVersion the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AgreementFileVersion> postAsync(@Nonnull final AgreementFileVersion newAgreementFileVersion) {
        return sendAsync(HttpMethod.POST, newAgreementFileVersion);
    }

    /**
     * Creates a AgreementFileVersion with a new object
     *
     * @param newAgreementFileVersion the new object to create
     * @return the created AgreementFileVersion
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AgreementFileVersion post(@Nonnull final AgreementFileVersion newAgreementFileVersion) throws ClientException {
        return send(HttpMethod.POST, newAgreementFileVersion);
    }

    /**
     * Creates a AgreementFileVersion with a new object
     *
     * @param newAgreementFileVersion the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AgreementFileVersion> putAsync(@Nonnull final AgreementFileVersion newAgreementFileVersion) {
        return sendAsync(HttpMethod.PUT, newAgreementFileVersion);
    }

    /**
     * Creates a AgreementFileVersion with a new object
     *
     * @param newAgreementFileVersion the object to create/update
     * @return the created AgreementFileVersion
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AgreementFileVersion put(@Nonnull final AgreementFileVersion newAgreementFileVersion) throws ClientException {
        return send(HttpMethod.PUT, newAgreementFileVersion);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public AgreementFileVersionRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public AgreementFileVersionRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

