// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.DeviceManagementExchangeConnectorSyncType;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Device Management Exchange Connector Sync Parameter Set.
 */
public class DeviceManagementExchangeConnectorSyncParameterSet {
    /**
     * The sync Type.
     * 
     */
    @SerializedName(value = "syncType", alternate = {"SyncType"})
    @Expose
	@Nullable
    public DeviceManagementExchangeConnectorSyncType syncType;


    /**
     * Instiaciates a new DeviceManagementExchangeConnectorSyncParameterSet
     */
    public DeviceManagementExchangeConnectorSyncParameterSet() {}
    /**
     * Instiaciates a new DeviceManagementExchangeConnectorSyncParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected DeviceManagementExchangeConnectorSyncParameterSet(@Nonnull final DeviceManagementExchangeConnectorSyncParameterSetBuilder builder) {
        this.syncType = builder.syncType;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static DeviceManagementExchangeConnectorSyncParameterSetBuilder newBuilder() {
        return new DeviceManagementExchangeConnectorSyncParameterSetBuilder();
    }
    /**
     * Fluent builder for the DeviceManagementExchangeConnectorSyncParameterSet
     */
    public static final class DeviceManagementExchangeConnectorSyncParameterSetBuilder {
        /**
         * The syncType parameter value
         */
        @Nullable
        protected DeviceManagementExchangeConnectorSyncType syncType;
        /**
         * Sets the SyncType
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public DeviceManagementExchangeConnectorSyncParameterSetBuilder withSyncType(@Nullable final DeviceManagementExchangeConnectorSyncType val) {
            this.syncType = val;
            return this;
        }
        /**
         * Instanciates a new DeviceManagementExchangeConnectorSyncParameterSetBuilder
         */
        @Nullable
        protected DeviceManagementExchangeConnectorSyncParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public DeviceManagementExchangeConnectorSyncParameterSet build() {
            return new DeviceManagementExchangeConnectorSyncParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.syncType != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("syncType", syncType));
        }
        return result;
    }
}
