// Template Source: BaseEntityCollectionRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.TodoTaskList;
import com.microsoft.graph.models.extensions.TodoTask;
import java.util.Arrays;
import java.util.EnumSet;

import com.microsoft.graph.requests.extensions.ITodoTaskCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ITodoTaskRequestBuilder;
import com.microsoft.graph.requests.extensions.ITodoTaskCollectionRequest;
import com.microsoft.graph.requests.extensions.ITodoTaskDeltaCollectionRequestBuilder;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.core.IBaseClient;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Todo Task Collection Request Builder.
 */
public class TodoTaskCollectionRequestBuilder extends BaseRequestBuilder implements ITodoTaskCollectionRequestBuilder {

    /**
     * The request builder for this collection of TodoTaskList
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public TodoTaskCollectionRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the IUserRequest instance
     */
    public ITodoTaskCollectionRequest buildRequest(final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the IUserRequest instance
     */
    public ITodoTaskCollectionRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new TodoTaskCollectionRequest(getRequestUrl(), getClient(), requestOptions);
    }

    public ITodoTaskRequestBuilder byId(final String id) {
        return new TodoTaskRequestBuilder(getRequestUrlWithAdditionalSegment(id), getClient(), getOptions());
    }



    public ITodoTaskDeltaCollectionRequestBuilder delta() {
        return new TodoTaskDeltaCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.delta"), getClient(), null);
    }

	public ITodoTaskDeltaCollectionRequestBuilder delta(final String deltaLink) {
        return new TodoTaskDeltaCollectionRequestBuilder(deltaLink, getClient(), null);
    }
}
