// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.TeamsTemplate;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Teams Template Request.
 */
public class TeamsTemplateRequest extends BaseRequest implements ITeamsTemplateRequest {
	
    /**
     * The request for the TeamsTemplate
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public TeamsTemplateRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, TeamsTemplate.class);
    }

    /**
     * Gets the TeamsTemplate from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<? super TeamsTemplate> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the TeamsTemplate from the service
     *
     * @return the TeamsTemplate from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public TeamsTemplate get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<? super TeamsTemplate> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this TeamsTemplate with a source
     *
     * @param sourceTeamsTemplate the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final TeamsTemplate sourceTeamsTemplate, final ICallback<? super TeamsTemplate> callback) {
        send(HttpMethod.PATCH, callback, sourceTeamsTemplate);
    }

    /**
     * Patches this TeamsTemplate with a source
     *
     * @param sourceTeamsTemplate the source object with updates
     * @return the updated TeamsTemplate
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public TeamsTemplate patch(final TeamsTemplate sourceTeamsTemplate) throws ClientException {
        return send(HttpMethod.PATCH, sourceTeamsTemplate);
    }

    /**
     * Creates a TeamsTemplate with a new object
     *
     * @param newTeamsTemplate the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final TeamsTemplate newTeamsTemplate, final ICallback<? super TeamsTemplate> callback) {
        send(HttpMethod.POST, callback, newTeamsTemplate);
    }

    /**
     * Creates a TeamsTemplate with a new object
     *
     * @param newTeamsTemplate the new object to create
     * @return the created TeamsTemplate
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public TeamsTemplate post(final TeamsTemplate newTeamsTemplate) throws ClientException {
        return send(HttpMethod.POST, newTeamsTemplate);
    }

    /**
     * Creates a TeamsTemplate with a new object
     *
     * @param newTeamsTemplate the object to create/update
     * @param callback the callback to be called after success or failure
     */
    public void put(final TeamsTemplate newTeamsTemplate, final ICallback<? super TeamsTemplate> callback) {
        send(HttpMethod.PUT, callback, newTeamsTemplate);
    }

    /**
     * Creates a TeamsTemplate with a new object
     *
     * @param newTeamsTemplate the object to create/update
     * @return the created TeamsTemplate
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public TeamsTemplate put(final TeamsTemplate newTeamsTemplate) throws ClientException {
        return send(HttpMethod.PUT, newTeamsTemplate);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public ITeamsTemplateRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (TeamsTemplateRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public ITeamsTemplateRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (TeamsTemplateRequest)this;
     }

}

