// Template Source: IBaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.WorkbookRangeFill;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Workbook Range Fill Request.
 */
public interface IWorkbookRangeFillRequest extends IHttpRequest {

    /**
     * Gets the WorkbookRangeFill from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super WorkbookRangeFill> callback);

    /**
     * Gets the WorkbookRangeFill from the service
     *
     * @return the WorkbookRangeFill from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookRangeFill get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super WorkbookRangeFill> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this WorkbookRangeFill with a source
     *
     * @param sourceWorkbookRangeFill the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final WorkbookRangeFill sourceWorkbookRangeFill, final ICallback<? super WorkbookRangeFill> callback);

    /**
     * Patches this WorkbookRangeFill with a source
     *
     * @param sourceWorkbookRangeFill the source object with updates
     * @return the updated WorkbookRangeFill
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookRangeFill patch(final WorkbookRangeFill sourceWorkbookRangeFill) throws ClientException;

    /**
     * Posts a WorkbookRangeFill with a new object
     *
     * @param newWorkbookRangeFill the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final WorkbookRangeFill newWorkbookRangeFill, final ICallback<? super WorkbookRangeFill> callback);

    /**
     * Posts a WorkbookRangeFill with a new object
     *
     * @param newWorkbookRangeFill the new object to create
     * @return the created WorkbookRangeFill
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookRangeFill post(final WorkbookRangeFill newWorkbookRangeFill) throws ClientException;

    /**
     * Posts a WorkbookRangeFill with a new object
     *
     * @param newWorkbookRangeFill the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final WorkbookRangeFill newWorkbookRangeFill, final ICallback<? super WorkbookRangeFill> callback);

    /**
     * Posts a WorkbookRangeFill with a new object
     *
     * @param newWorkbookRangeFill the object to create/update
     * @return the created WorkbookRangeFill
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookRangeFill put(final WorkbookRangeFill newWorkbookRangeFill) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IWorkbookRangeFillRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IWorkbookRangeFillRequest expand(final String value);

}

