// Template Source: IBaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.WorkbookChartSeries;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Workbook Chart Series Request.
 */
public interface IWorkbookChartSeriesRequest extends IHttpRequest {

    /**
     * Gets the WorkbookChartSeries from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super WorkbookChartSeries> callback);

    /**
     * Gets the WorkbookChartSeries from the service
     *
     * @return the WorkbookChartSeries from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookChartSeries get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super WorkbookChartSeries> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this WorkbookChartSeries with a source
     *
     * @param sourceWorkbookChartSeries the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final WorkbookChartSeries sourceWorkbookChartSeries, final ICallback<? super WorkbookChartSeries> callback);

    /**
     * Patches this WorkbookChartSeries with a source
     *
     * @param sourceWorkbookChartSeries the source object with updates
     * @return the updated WorkbookChartSeries
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookChartSeries patch(final WorkbookChartSeries sourceWorkbookChartSeries) throws ClientException;

    /**
     * Posts a WorkbookChartSeries with a new object
     *
     * @param newWorkbookChartSeries the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final WorkbookChartSeries newWorkbookChartSeries, final ICallback<? super WorkbookChartSeries> callback);

    /**
     * Posts a WorkbookChartSeries with a new object
     *
     * @param newWorkbookChartSeries the new object to create
     * @return the created WorkbookChartSeries
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookChartSeries post(final WorkbookChartSeries newWorkbookChartSeries) throws ClientException;

    /**
     * Posts a WorkbookChartSeries with a new object
     *
     * @param newWorkbookChartSeries the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final WorkbookChartSeries newWorkbookChartSeries, final ICallback<? super WorkbookChartSeries> callback);

    /**
     * Posts a WorkbookChartSeries with a new object
     *
     * @param newWorkbookChartSeries the object to create/update
     * @return the created WorkbookChartSeries
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookChartSeries put(final WorkbookChartSeries newWorkbookChartSeries) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IWorkbookChartSeriesRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IWorkbookChartSeriesRequest expand(final String value);

}

