// Template Source: IBaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.PlannerBucketTaskBoardTaskFormat;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Planner Bucket Task Board Task Format Request.
 */
public interface IPlannerBucketTaskBoardTaskFormatRequest extends IHttpRequest {

    /**
     * Gets the PlannerBucketTaskBoardTaskFormat from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super PlannerBucketTaskBoardTaskFormat> callback);

    /**
     * Gets the PlannerBucketTaskBoardTaskFormat from the service
     *
     * @return the PlannerBucketTaskBoardTaskFormat from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    PlannerBucketTaskBoardTaskFormat get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super PlannerBucketTaskBoardTaskFormat> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this PlannerBucketTaskBoardTaskFormat with a source
     *
     * @param sourcePlannerBucketTaskBoardTaskFormat the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final PlannerBucketTaskBoardTaskFormat sourcePlannerBucketTaskBoardTaskFormat, final ICallback<? super PlannerBucketTaskBoardTaskFormat> callback);

    /**
     * Patches this PlannerBucketTaskBoardTaskFormat with a source
     *
     * @param sourcePlannerBucketTaskBoardTaskFormat the source object with updates
     * @return the updated PlannerBucketTaskBoardTaskFormat
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    PlannerBucketTaskBoardTaskFormat patch(final PlannerBucketTaskBoardTaskFormat sourcePlannerBucketTaskBoardTaskFormat) throws ClientException;

    /**
     * Posts a PlannerBucketTaskBoardTaskFormat with a new object
     *
     * @param newPlannerBucketTaskBoardTaskFormat the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final PlannerBucketTaskBoardTaskFormat newPlannerBucketTaskBoardTaskFormat, final ICallback<? super PlannerBucketTaskBoardTaskFormat> callback);

    /**
     * Posts a PlannerBucketTaskBoardTaskFormat with a new object
     *
     * @param newPlannerBucketTaskBoardTaskFormat the new object to create
     * @return the created PlannerBucketTaskBoardTaskFormat
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    PlannerBucketTaskBoardTaskFormat post(final PlannerBucketTaskBoardTaskFormat newPlannerBucketTaskBoardTaskFormat) throws ClientException;

    /**
     * Posts a PlannerBucketTaskBoardTaskFormat with a new object
     *
     * @param newPlannerBucketTaskBoardTaskFormat the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final PlannerBucketTaskBoardTaskFormat newPlannerBucketTaskBoardTaskFormat, final ICallback<? super PlannerBucketTaskBoardTaskFormat> callback);

    /**
     * Posts a PlannerBucketTaskBoardTaskFormat with a new object
     *
     * @param newPlannerBucketTaskBoardTaskFormat the object to create/update
     * @return the created PlannerBucketTaskBoardTaskFormat
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    PlannerBucketTaskBoardTaskFormat put(final PlannerBucketTaskBoardTaskFormat newPlannerBucketTaskBoardTaskFormat) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IPlannerBucketTaskBoardTaskFormatRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IPlannerBucketTaskBoardTaskFormatRequest expand(final String value);

}

