// Template Source: IBaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.ManagedDeviceMobileAppConfigurationDeviceStatus;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Managed Device Mobile App Configuration Device Status Request.
 */
public interface IManagedDeviceMobileAppConfigurationDeviceStatusRequest extends IHttpRequest {

    /**
     * Gets the ManagedDeviceMobileAppConfigurationDeviceStatus from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super ManagedDeviceMobileAppConfigurationDeviceStatus> callback);

    /**
     * Gets the ManagedDeviceMobileAppConfigurationDeviceStatus from the service
     *
     * @return the ManagedDeviceMobileAppConfigurationDeviceStatus from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ManagedDeviceMobileAppConfigurationDeviceStatus get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super ManagedDeviceMobileAppConfigurationDeviceStatus> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this ManagedDeviceMobileAppConfigurationDeviceStatus with a source
     *
     * @param sourceManagedDeviceMobileAppConfigurationDeviceStatus the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final ManagedDeviceMobileAppConfigurationDeviceStatus sourceManagedDeviceMobileAppConfigurationDeviceStatus, final ICallback<? super ManagedDeviceMobileAppConfigurationDeviceStatus> callback);

    /**
     * Patches this ManagedDeviceMobileAppConfigurationDeviceStatus with a source
     *
     * @param sourceManagedDeviceMobileAppConfigurationDeviceStatus the source object with updates
     * @return the updated ManagedDeviceMobileAppConfigurationDeviceStatus
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ManagedDeviceMobileAppConfigurationDeviceStatus patch(final ManagedDeviceMobileAppConfigurationDeviceStatus sourceManagedDeviceMobileAppConfigurationDeviceStatus) throws ClientException;

    /**
     * Posts a ManagedDeviceMobileAppConfigurationDeviceStatus with a new object
     *
     * @param newManagedDeviceMobileAppConfigurationDeviceStatus the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final ManagedDeviceMobileAppConfigurationDeviceStatus newManagedDeviceMobileAppConfigurationDeviceStatus, final ICallback<? super ManagedDeviceMobileAppConfigurationDeviceStatus> callback);

    /**
     * Posts a ManagedDeviceMobileAppConfigurationDeviceStatus with a new object
     *
     * @param newManagedDeviceMobileAppConfigurationDeviceStatus the new object to create
     * @return the created ManagedDeviceMobileAppConfigurationDeviceStatus
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ManagedDeviceMobileAppConfigurationDeviceStatus post(final ManagedDeviceMobileAppConfigurationDeviceStatus newManagedDeviceMobileAppConfigurationDeviceStatus) throws ClientException;

    /**
     * Posts a ManagedDeviceMobileAppConfigurationDeviceStatus with a new object
     *
     * @param newManagedDeviceMobileAppConfigurationDeviceStatus the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final ManagedDeviceMobileAppConfigurationDeviceStatus newManagedDeviceMobileAppConfigurationDeviceStatus, final ICallback<? super ManagedDeviceMobileAppConfigurationDeviceStatus> callback);

    /**
     * Posts a ManagedDeviceMobileAppConfigurationDeviceStatus with a new object
     *
     * @param newManagedDeviceMobileAppConfigurationDeviceStatus the object to create/update
     * @return the created ManagedDeviceMobileAppConfigurationDeviceStatus
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ManagedDeviceMobileAppConfigurationDeviceStatus put(final ManagedDeviceMobileAppConfigurationDeviceStatus newManagedDeviceMobileAppConfigurationDeviceStatus) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IManagedDeviceMobileAppConfigurationDeviceStatusRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IManagedDeviceMobileAppConfigurationDeviceStatusRequest expand(final String value);

}

