// Template Source: IBaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.ManagedApp;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Managed App Request.
 */
public interface IManagedAppRequest extends IHttpRequest {

    /**
     * Gets the ManagedApp from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super ManagedApp> callback);

    /**
     * Gets the ManagedApp from the service
     *
     * @return the ManagedApp from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ManagedApp get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super ManagedApp> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this ManagedApp with a source
     *
     * @param sourceManagedApp the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final ManagedApp sourceManagedApp, final ICallback<? super ManagedApp> callback);

    /**
     * Patches this ManagedApp with a source
     *
     * @param sourceManagedApp the source object with updates
     * @return the updated ManagedApp
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ManagedApp patch(final ManagedApp sourceManagedApp) throws ClientException;

    /**
     * Posts a ManagedApp with a new object
     *
     * @param newManagedApp the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final ManagedApp newManagedApp, final ICallback<? super ManagedApp> callback);

    /**
     * Posts a ManagedApp with a new object
     *
     * @param newManagedApp the new object to create
     * @return the created ManagedApp
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ManagedApp post(final ManagedApp newManagedApp) throws ClientException;

    /**
     * Posts a ManagedApp with a new object
     *
     * @param newManagedApp the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final ManagedApp newManagedApp, final ICallback<? super ManagedApp> callback);

    /**
     * Posts a ManagedApp with a new object
     *
     * @param newManagedApp the object to create/update
     * @return the created ManagedApp
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ManagedApp put(final ManagedApp newManagedApp) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IManagedAppRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IManagedAppRequest expand(final String value);

}

