// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.Authentication;
import com.microsoft.graph.requests.extensions.IFido2AuthenticationMethodCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IFido2AuthenticationMethodRequestBuilder;
import com.microsoft.graph.requests.extensions.Fido2AuthenticationMethodCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.Fido2AuthenticationMethodRequestBuilder;
import com.microsoft.graph.requests.extensions.IAuthenticationMethodCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IAuthenticationMethodRequestBuilder;
import com.microsoft.graph.requests.extensions.AuthenticationMethodCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.AuthenticationMethodRequestBuilder;
import com.microsoft.graph.requests.extensions.IMicrosoftAuthenticatorAuthenticationMethodCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IMicrosoftAuthenticatorAuthenticationMethodRequestBuilder;
import com.microsoft.graph.requests.extensions.MicrosoftAuthenticatorAuthenticationMethodCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.MicrosoftAuthenticatorAuthenticationMethodRequestBuilder;
import com.microsoft.graph.requests.extensions.IWindowsHelloForBusinessAuthenticationMethodCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IWindowsHelloForBusinessAuthenticationMethodRequestBuilder;
import com.microsoft.graph.requests.extensions.WindowsHelloForBusinessAuthenticationMethodCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.WindowsHelloForBusinessAuthenticationMethodRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Authentication Request Builder.
 */
public class AuthenticationRequestBuilder extends BaseRequestBuilder implements IAuthenticationRequestBuilder {

    /**
     * The request builder for the Authentication
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AuthenticationRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the IAuthenticationRequest instance
     */
    public IAuthenticationRequest buildRequest(final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the IAuthenticationRequest instance
     */
    public IAuthenticationRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.requests.extensions.AuthenticationRequest(getRequestUrl(), getClient(), requestOptions);
    }


    public IFido2AuthenticationMethodCollectionRequestBuilder fido2Methods() {
        return new Fido2AuthenticationMethodCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("fido2Methods"), getClient(), null);
    }

    public IFido2AuthenticationMethodRequestBuilder fido2Methods(final String id) {
        return new Fido2AuthenticationMethodRequestBuilder(getRequestUrlWithAdditionalSegment("fido2Methods") + "/" + id, getClient(), null);
    }
    public IAuthenticationMethodCollectionRequestBuilder methods() {
        return new AuthenticationMethodCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("methods"), getClient(), null);
    }

    public IAuthenticationMethodRequestBuilder methods(final String id) {
        return new AuthenticationMethodRequestBuilder(getRequestUrlWithAdditionalSegment("methods") + "/" + id, getClient(), null);
    }
    public IMicrosoftAuthenticatorAuthenticationMethodCollectionRequestBuilder microsoftAuthenticatorMethods() {
        return new MicrosoftAuthenticatorAuthenticationMethodCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("microsoftAuthenticatorMethods"), getClient(), null);
    }

    public IMicrosoftAuthenticatorAuthenticationMethodRequestBuilder microsoftAuthenticatorMethods(final String id) {
        return new MicrosoftAuthenticatorAuthenticationMethodRequestBuilder(getRequestUrlWithAdditionalSegment("microsoftAuthenticatorMethods") + "/" + id, getClient(), null);
    }
    public IWindowsHelloForBusinessAuthenticationMethodCollectionRequestBuilder windowsHelloForBusinessMethods() {
        return new WindowsHelloForBusinessAuthenticationMethodCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("windowsHelloForBusinessMethods"), getClient(), null);
    }

    public IWindowsHelloForBusinessAuthenticationMethodRequestBuilder windowsHelloForBusinessMethods(final String id) {
        return new WindowsHelloForBusinessAuthenticationMethodRequestBuilder(getRequestUrlWithAdditionalSegment("windowsHelloForBusinessMethods") + "/" + id, getClient(), null);
    }
}
