// Template Source: BaseEntityCollectionRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.Fido2AuthenticationMethodConfiguration;
import com.microsoft.graph.models.extensions.AuthenticationMethodTarget;
import java.util.Arrays;
import java.util.EnumSet;

import com.microsoft.graph.requests.extensions.IAuthenticationMethodTargetCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IAuthenticationMethodTargetRequestBuilder;
import com.microsoft.graph.requests.extensions.IAuthenticationMethodTargetCollectionRequest;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.core.IBaseClient;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Authentication Method Target Collection Request Builder.
 */
public class AuthenticationMethodTargetCollectionRequestBuilder extends BaseRequestBuilder implements IAuthenticationMethodTargetCollectionRequestBuilder {

    /**
     * The request builder for this collection of Fido2AuthenticationMethodConfiguration
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AuthenticationMethodTargetCollectionRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the IUserRequest instance
     */
    public IAuthenticationMethodTargetCollectionRequest buildRequest(final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the IUserRequest instance
     */
    public IAuthenticationMethodTargetCollectionRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new AuthenticationMethodTargetCollectionRequest(getRequestUrl(), getClient(), requestOptions);
    }

    public IAuthenticationMethodTargetRequestBuilder byId(final String id) {
        return new AuthenticationMethodTargetRequestBuilder(getRequestUrlWithAdditionalSegment(id), getClient(), getOptions());
    }


}
