// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.extensions.CallOptions;
import com.microsoft.graph.models.extensions.CallRoute;
import com.microsoft.graph.models.extensions.ChatInfo;
import com.microsoft.graph.models.generated.CallDirection;
import com.microsoft.graph.models.extensions.IncomingContext;
import com.microsoft.graph.models.extensions.MediaConfig;
import com.microsoft.graph.models.extensions.CallMediaState;
import com.microsoft.graph.models.extensions.MeetingInfo;
import com.microsoft.graph.models.generated.Modality;
import com.microsoft.graph.models.extensions.ResultInfo;
import com.microsoft.graph.models.extensions.ParticipantInfo;
import com.microsoft.graph.models.generated.CallState;
import com.microsoft.graph.models.extensions.InvitationParticipantInfo;
import com.microsoft.graph.models.extensions.ToneInfo;
import com.microsoft.graph.models.extensions.CallTranscriptionInfo;
import com.microsoft.graph.models.extensions.CommsOperation;
import com.microsoft.graph.models.extensions.Participant;
import com.microsoft.graph.models.extensions.Entity;
import com.microsoft.graph.requests.extensions.CommsOperationCollectionPage;
import com.microsoft.graph.requests.extensions.ParticipantCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Call.
 */
public class Call extends Entity implements IJsonBackedObject {


    /**
     * The Callback Uri.
     * The callback URL on which callbacks will be delivered. Must be https.
     */
    @SerializedName(value = "callbackUri", alternate = {"CallbackUri"})
    @Expose
    public String callbackUri;

    /**
     * The Call Chain Id.
     * A unique identifier for all the participant calls in a conference or a unique identifier for two participant calls in a P2P call.  This needs to be copied over from Microsoft.Graph.Call.CallChainId.
     */
    @SerializedName(value = "callChainId", alternate = {"CallChainId"})
    @Expose
    public String callChainId;

    /**
     * The Call Options.
     * 
     */
    @SerializedName(value = "callOptions", alternate = {"CallOptions"})
    @Expose
    public CallOptions callOptions;

    /**
     * The Call Routes.
     * The routing information on how the call was retargeted. Read-only.
     */
    @SerializedName(value = "callRoutes", alternate = {"CallRoutes"})
    @Expose
    public java.util.List<CallRoute> callRoutes;

    /**
     * The Chat Info.
     * The chat information. Required information for meeting scenarios.
     */
    @SerializedName(value = "chatInfo", alternate = {"ChatInfo"})
    @Expose
    public ChatInfo chatInfo;

    /**
     * The Direction.
     * The direction of the call. The possible value are incoming or outgoing. Read-only.
     */
    @SerializedName(value = "direction", alternate = {"Direction"})
    @Expose
    public CallDirection direction;

    /**
     * The Incoming Context.
     * The context associated with an incoming call. Read-only. Server generated.
     */
    @SerializedName(value = "incomingContext", alternate = {"IncomingContext"})
    @Expose
    public IncomingContext incomingContext;

    /**
     * The Media Config.
     * The media configuration. Required information for creating peer to peer calls or joining meetings.
     */
    @SerializedName(value = "mediaConfig", alternate = {"MediaConfig"})
    @Expose
    public MediaConfig mediaConfig;

    /**
     * The Media State.
     * Read-only. The call media state.
     */
    @SerializedName(value = "mediaState", alternate = {"MediaState"})
    @Expose
    public CallMediaState mediaState;

    /**
     * The Meeting Info.
     * The meeting information. Required information for meeting scenarios.
     */
    @SerializedName(value = "meetingInfo", alternate = {"MeetingInfo"})
    @Expose
    public MeetingInfo meetingInfo;

    /**
     * The My Participant Id.
     * 
     */
    @SerializedName(value = "myParticipantId", alternate = {"MyParticipantId"})
    @Expose
    public String myParticipantId;

    /**
     * The Requested Modalities.
     * 
     */
    @SerializedName(value = "requestedModalities", alternate = {"RequestedModalities"})
    @Expose
    public java.util.List<Modality> requestedModalities;

    /**
     * The Result Info.
     * 
     */
    @SerializedName(value = "resultInfo", alternate = {"ResultInfo"})
    @Expose
    public ResultInfo resultInfo;

    /**
     * The Source.
     * 
     */
    @SerializedName(value = "source", alternate = {"Source"})
    @Expose
    public ParticipantInfo source;

    /**
     * The State.
     * 
     */
    @SerializedName(value = "state", alternate = {"State"})
    @Expose
    public CallState state;

    /**
     * The Subject.
     * 
     */
    @SerializedName(value = "subject", alternate = {"Subject"})
    @Expose
    public String subject;

    /**
     * The Targets.
     * 
     */
    @SerializedName(value = "targets", alternate = {"Targets"})
    @Expose
    public java.util.List<InvitationParticipantInfo> targets;

    /**
     * The Tenant Id.
     * 
     */
    @SerializedName(value = "tenantId", alternate = {"TenantId"})
    @Expose
    public String tenantId;

    /**
     * The Tone Info.
     * 
     */
    @SerializedName(value = "toneInfo", alternate = {"ToneInfo"})
    @Expose
    public ToneInfo toneInfo;

    /**
     * The Transcription.
     * The transcription information for the call. Read-only.
     */
    @SerializedName(value = "transcription", alternate = {"Transcription"})
    @Expose
    public CallTranscriptionInfo transcription;

    /**
     * The Operations.
     * Read-only. Nullable.
     */
    @SerializedName(value = "operations", alternate = {"Operations"})
    @Expose
    public CommsOperationCollectionPage operations;

    /**
     * The Participants.
     * Read-only. Nullable.
     */
    @SerializedName(value = "participants", alternate = {"Participants"})
    @Expose
    public ParticipantCollectionPage participants;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;


        if (json.has("operations")) {
            operations = serializer.deserializeObject(json.get("operations").toString(), CommsOperationCollectionPage.class);
        }

        if (json.has("participants")) {
            participants = serializer.deserializeObject(json.get("participants").toString(), ParticipantCollectionPage.class);
        }
    }
}
