// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.generated.AllowInvitesFrom;
import com.microsoft.graph.models.extensions.DefaultUserRolePermissions;
import com.microsoft.graph.models.extensions.PolicyBase;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Authorization Policy.
 */
public class AuthorizationPolicy extends PolicyBase implements IJsonBackedObject {


    /**
     * The Allowed To Sign Up Email Based Subscriptions.
     * Indicates whether users can sign up for email based subscriptions.
     */
    @SerializedName(value = "allowedToSignUpEmailBasedSubscriptions", alternate = {"AllowedToSignUpEmailBasedSubscriptions"})
    @Expose
    public Boolean allowedToSignUpEmailBasedSubscriptions;

    /**
     * The Allowed To Use SSPR.
     * Indicates whether the Self-Serve Password Reset feature can be used by users on the tenant.
     */
    @SerializedName(value = "allowedToUseSSPR", alternate = {"AllowedToUseSSPR"})
    @Expose
    public Boolean allowedToUseSSPR;

    /**
     * The Allow Email Verified Users To Join Organization.
     * Indicates whether a user can join the tenant by email validation.
     */
    @SerializedName(value = "allowEmailVerifiedUsersToJoinOrganization", alternate = {"AllowEmailVerifiedUsersToJoinOrganization"})
    @Expose
    public Boolean allowEmailVerifiedUsersToJoinOrganization;

    /**
     * The Allow Invites From.
     * Indicates who can invite external users to the organization. Possible values are:none - Prevent everyone, including admins, from inviting external users. Default setting for US Government.adminsAndGuestInviters - Allow members of Global Administrators, User Administrators, and Guest Inviter roles to invite external users.adminsGuestInvitersAndAllMembers - Allow the above admin roles and all other User role members to invite external users.everyone - Allow everyone in the organization, including guest users, to invite external users. Default setting for all cloud environments except US Government.
     */
    @SerializedName(value = "allowInvitesFrom", alternate = {"AllowInvitesFrom"})
    @Expose
    public AllowInvitesFrom allowInvitesFrom;

    /**
     * The Block Msol Power Shell.
     * To disable the use of MSOL PowerShell set this property to true. Setting to true will also disable user-based access to the legacy service endpoint used by MSOL PowerShell. This does not affect Azure AD Connect or Microsoft Graph.
     */
    @SerializedName(value = "blockMsolPowerShell", alternate = {"BlockMsolPowerShell"})
    @Expose
    public Boolean blockMsolPowerShell;

    /**
     * The Default User Role Permissions.
     * Specifies certain customizable permissions for default user role.
     */
    @SerializedName(value = "defaultUserRolePermissions", alternate = {"DefaultUserRolePermissions"})
    @Expose
    public DefaultUserRolePermissions defaultUserRolePermissions;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;

    }
}
