/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.autoconfigure.sql;

import javax.annotation.PostConstruct;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.Assert;

@ConfigurationProperties(value="spring.cloud.azure.sql")
public class AzureSqlProperties {
    private String databaseName;
    private String serverName;

    @PostConstruct
    public void validate() {
        Assert.hasText((String)this.serverName, (String)"spring.cloud.azure.sql.serverName must be provided");
        Assert.hasText((String)this.databaseName, (String)"spring.cloud.azure.sql.databaseName must be provided");
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }
}

